/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="acceptUsersAuthenticationHandler")
public class AcceptUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_SEPARATOR = "::";
    private static final Pattern USERS_PASSWORDS_SPLITTER_PATTERN = Pattern.compile("::");
    private Map<String, String> users;
    @Value(value="${accept.authn.users:}")
    private String acceptedUsers;

    @PostConstruct
    public void init() {
        if (StringUtils.isNotBlank((CharSequence)this.acceptedUsers) && this.users == null) {
            Set usersPasswords = org.springframework.util.StringUtils.commaDelimitedListToSet((String)this.acceptedUsers);
            HashMap<String, String> parsedUsers = new HashMap<String, String>();
            for (String usersPassword : usersPasswords) {
                String[] splitArray = USERS_PASSWORDS_SPLITTER_PATTERN.split(usersPassword);
                parsedUsers.put(splitArray[0], splitArray[1]);
            }
            this.setUsers(parsedUsers);
        }
    }

    @Override
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        if (this.users == null || this.users.isEmpty()) {
            throw new FailedLoginException("No user can be accepted because none is defined");
        }
        String username = credential.getUsername();
        String cachedPassword = this.users.get(username);
        if (cachedPassword == null) {
            this.logger.debug("{} was not found in the map.", (Object)username);
            throw new AccountNotFoundException(String.valueOf(username) + " not found in backing map.");
        }
        String encodedPassword = this.getPasswordEncoder().encode(credential.getPassword());
        if (!cachedPassword.equals(encodedPassword)) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), null);
    }

    public final void setUsers(@NotNull Map<String, String> users) {
        this.users = Collections.unmodifiableMap(users);
    }
}

