/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jasig.cas.authentication.Credential;

public final class AuthenticationTransaction
implements Serializable {
    private static final long serialVersionUID = 6213904009424725484L;
    private final Collection<Credential> credentials;

    private AuthenticationTransaction(Collection<Credential> credentials) {
        this.credentials = credentials;
    }

    public Collection<Credential> getCredentials() {
        return this.credentials;
    }

    public static AuthenticationTransaction wrap(Credential ... credentials) {
        return new AuthenticationTransaction(AuthenticationTransaction.sanitizeCredentials(credentials));
    }

    private static Set<Credential> sanitizeCredentials(Credential[] credentials) {
        if (credentials != null && credentials.length > 0) {
            HashSet<Credential> set = new HashSet<Credential>(Arrays.asList(credentials));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return set;
        }
        return Collections.emptySet();
    }
}

