/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.jasig.cas.util.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJacksonBackedJsonSerializer<T>
implements JsonSerializer<T> {
    private static final long serialVersionUID = -8415599777321259365L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJacksonBackedJsonSerializer.class);
    private final PrettyPrinter prettyPrinter;
    private final ObjectMapper objectMapper;

    public AbstractJacksonBackedJsonSerializer() {
        this((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public AbstractJacksonBackedJsonSerializer(PrettyPrinter prettyPrinter) {
        this.objectMapper = this.initializeObjectMapper();
        this.prettyPrinter = prettyPrinter;
    }

    public AbstractJacksonBackedJsonSerializer(ObjectMapper objectMapper, PrettyPrinter prettyPrinter) {
        this.objectMapper = objectMapper;
        this.prettyPrinter = prettyPrinter;
    }

    @Override
    public T fromJson(String json) {
        try {
            return (T)this.objectMapper.readValue(json, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T fromJson(File json) {
        try {
            return (T)this.objectMapper.readValue(json, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T fromJson(Reader json) {
        try {
            return (T)this.objectMapper.readValue(json, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T fromJson(InputStream json) {
        try {
            return (T)this.objectMapper.readValue(json, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void toJson(OutputStream out, T object) {
        try {
            this.objectMapper.writer(this.prettyPrinter).writeValue(out, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void toJson(Writer out, T object) {
        try {
            this.objectMapper.writer(this.prettyPrinter).writeValue(out, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void toJson(File out, T object) {
        try {
            this.objectMapper.writer(this.prettyPrinter).writeValue(out, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return mapper;
    }

    protected abstract Class<T> getTypeToSerialize();
}

