/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.util.Assert;

public final class SimplePrincipal
implements Principal {
    private static final long serialVersionUID = -1255260750151385796L;
    private final String id;
    private final Map<String, Object> attributes;

    private SimplePrincipal() {
        this.id = null;
        this.attributes = new HashMap<String, Object>();
    }

    private SimplePrincipal(String id) {
        this(id, Collections.EMPTY_MAP);
    }

    public SimplePrincipal(String id, Map<String, Object> attributes) {
        Assert.notNull((Object)id, (String)"principal id cannot be null");
        Assert.notNull((Object)id, (String)"principal attributes cannot be null");
        this.id = id;
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(83, 31);
        builder.append((Object)this.id.toLowerCase());
        return builder.toHashCode();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SimplePrincipal rhs = (SimplePrincipal)obj;
        return StringUtils.equalsIgnoreCase((CharSequence)this.id, (CharSequence)rhs.id);
    }
}

