/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AcceptAnyAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.ContextualAuthenticationPolicy;
import org.jasig.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceContext;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedServiceForPrincipalException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.UnrecognizableServiceForServiceTicketValidationException;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertion;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final TicketRegistry ticketRegistry;
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final LogoutManager logoutManager;
    @NotNull
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    @NotNull
    private ExpirationPolicy serviceTicketExpirationPolicy;
    @NotNull
    private ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory = new AcceptAnyAuthenticationPolicyFactory();
    @NotNull
    private PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    @NotNull
    private final UniqueTicketIdGenerator defaultServiceTicketIdGenerator = new DefaultUniqueTicketIdGenerator();

    public CentralAuthenticationServiceImpl(TicketRegistry ticketRegistry, AuthenticationManager authenticationManager, UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService, ExpirationPolicy ticketGrantingTicketExpirationPolicy, ExpirationPolicy serviceTicketExpirationPolicy, ServicesManager servicesManager, LogoutManager logoutManager) {
        this.ticketRegistry = ticketRegistry;
        this.authenticationManager = authenticationManager;
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
        this.servicesManager = servicesManager;
        this.logoutManager = logoutManager;
    }

    @Audit(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="DESTROY_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="DESTROY_TICKET_GRANTING_TICKET_METER")
    @Counted(name="DESTROY_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public List<LogoutRequest> destroyTicketGrantingTicket(@NotNull String ticketGrantingTicketId) {
        try {
            this.logger.debug("Removing ticket [{}] from registry...", (Object)ticketGrantingTicketId);
            TicketGrantingTicket ticket = (TicketGrantingTicket)this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            this.logger.debug("Ticket found. Processing logout requests and then deleting the ticket...");
            List logoutRequests = this.logoutManager.performLogout(ticket);
            this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
            return logoutRequests;
        }
        catch (InvalidTicketException e) {
            this.logger.debug("TicketGrantingTicket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_SERVICE_TICKET_TIMER")
    @Metered(name="GRANT_SERVICE_TICKET_METER")
    @Counted(name="GRANT_SERVICE_TICKET_COUNTER", monotonic=true)
    public ServiceTicket grantServiceTicket(String ticketGrantingTicketId, Service service, Credential ... credentials) throws AuthenticationException, TicketException {
        Service proxiedBy;
        this.logger.debug("Attempting to get ticket id {} to create service ticket", (Object)ticketGrantingTicketId);
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        this.verifyRegisteredServiceProperties(registeredService, service);
        Set<Credential> sanitizedCredentials = CentralAuthenticationServiceImpl.sanitizeCredentials(credentials);
        if (sanitizedCredentials.isEmpty() && !registeredService.getAccessStrategy().isServiceAccessAllowedForSso()) {
            if (ticketGrantingTicket.getProxiedBy() != null) {
                this.logger.warn("ServiceManagement: Service [{}] is not allowed to use SSO for proxying.", (Object)service.getId());
                throw new UnauthorizedSsoServiceException();
            }
            if (ticketGrantingTicket.getProxiedBy() == null && ticketGrantingTicket.getCountOfUses() > 0) {
                this.logger.warn("ServiceManagement: Service [{}] is not allowed to use SSO.", (Object)service.getId());
                throw new UnauthorizedSsoServiceException();
            }
        }
        Authentication currentAuthentication = null;
        if (!sanitizedCredentials.isEmpty()) {
            this.logger.debug("Attempting to authenticate sanitized credentials to create service ticket");
            currentAuthentication = this.authenticationManager.authenticate(sanitizedCredentials.toArray(new Credential[0]));
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!currentAuthentication.getPrincipal().equals(original.getPrincipal())) {
                this.logger.debug("Principal associated with current authentication {} does not match the principal {} associated with the original authentication", (Object)currentAuthentication.getPrincipal(), (Object)original.getPrincipal());
                throw new MixedPrincipalException(currentAuthentication, currentAuthentication.getPrincipal(), original.getPrincipal());
            }
            this.logger.debug("Added authentication to the collection of supplemental authentications");
            ticketGrantingTicket.getSupplementalAuthentications().add(currentAuthentication);
        }
        if ((proxiedBy = ticketGrantingTicket.getProxiedBy()) != null) {
            this.logger.debug("TGT is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            RegisteredService proxyingService = this.servicesManager.findServiceBy(proxiedBy);
            if (proxyingService == null) {
                this.logger.warn("No proxying service found. Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            this.logger.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
            if (!proxyingService.getProxyPolicy().isAllowedToProxy()) {
                this.logger.warn("Found proxying service {}, but it is not authorized to fulfill the proxy attempt made by {}", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
        } else {
            this.logger.debug("TGT is not proxied by another service");
        }
        this.logger.debug("Checking for authentication policy satisfaction...");
        this.getAuthenticationSatisfiedByPolicy(ticketGrantingTicket.getRoot(), new ServiceContext(service, registeredService));
        List authentications = ticketGrantingTicket.getChainedAuthentications();
        Principal principal = ((Authentication)authentications.get(authentications.size() - 1)).getPrincipal();
        this.logger.debug("Located principal {} for service ticket creation", (Object)principal);
        Map principalAttrs = registeredService.getAttributeReleasePolicy().getAttributes(principal);
        if (!registeredService.getAccessStrategy().doPrincipalAttributesAllowServiceAccess(principalAttrs)) {
            this.logger.warn("ServiceManagement: Cannot grant service ticket because Service [{}] is not authorized for use by [{}].", (Object)service.getId(), (Object)principal);
            throw new UnauthorizedServiceForPrincipalException();
        }
        String uniqueTicketIdGenKey = service.getClass().getName();
        this.logger.debug("Looking up service ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        if (serviceTicketUniqueTicketIdGenerator == null) {
            serviceTicketUniqueTicketIdGenerator = this.defaultServiceTicketIdGenerator;
            this.logger.debug("Service ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketPrefix = authentications.size() == 1 ? "ST" : "PT";
        String ticketId = serviceTicketUniqueTicketIdGenerator.getNewTicketId(ticketPrefix);
        this.logger.debug("Created new ticket id {}", (Object)ticketId);
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(ticketId, service, this.serviceTicketExpirationPolicy, currentAuthentication != null);
        this.logger.info("Granted ticket [{}] for service [{}] for user [{}]", new Object[]{serviceTicket.getId(), service.getId(), principal.getId()});
        this.ticketRegistry.addTicket((Ticket)serviceTicket);
        this.logger.debug("Added service ticket {} to ticket registry", (Object)serviceTicket.getId());
        return serviceTicket;
    }

    private static Set<Credential> sanitizeCredentials(Credential[] credentials) {
        if (credentials != null && credentials.length > 0) {
            HashSet<Credential> set = new HashSet<Credential>(Arrays.asList(credentials));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_SERVICE_TICKET_TIMER")
    @Metered(name="GRANT_SERVICE_TICKET_METER")
    @Counted(name="GRANT_SERVICE_TICKET_COUNTER", monotonic=true)
    public ServiceTicket grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        try {
            return this.grantServiceTicket(ticketGrantingTicketId, service, null);
        }
        catch (AuthenticationException e) {
            throw new IllegalStateException("Unexpected authentication exception", e);
        }
    }

    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="GRANT_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_PROXY_GRANTING_TICKET_TIMER")
    @Metered(name="GRANT_PROXY_GRANTING_TICKET_METER")
    @Counted(name="GRANT_PROXY_GRANTING_TICKET_COUNTER", monotonic=true)
    public TicketGrantingTicket delegateTicketGrantingTicket(String serviceTicketId, Credential ... credentials) throws AuthenticationException, TicketException {
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            this.logger.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(serviceTicket.getService());
        this.verifyRegisteredServiceProperties(registeredService, serviceTicket.getService());
        if (!registeredService.getProxyPolicy().isAllowedToProxy()) {
            this.logger.warn("ServiceManagement: Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        Authentication authentication = this.authenticationManager.authenticate(credentials);
        String pgtId = this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("PGT");
        TicketGrantingTicket proxyGrantingTicket = serviceTicket.grantTicketGrantingTicket(pgtId, authentication, this.ticketGrantingTicketExpirationPolicy);
        this.logger.debug("Generated proxy granting ticket [{}] based off of [{}]", (Object)proxyGrantingTicket, (Object)serviceTicketId);
        this.ticketRegistry.addTicket((Ticket)proxyGrantingTicket);
        return proxyGrantingTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="VALIDATE_SERVICE_TICKET_TIMER")
    @Metered(name="VALIDATE_SERVICE_TICKET_METER")
    @Counted(name="VALIDATE_SERVICE_TICKET_COUNTER", monotonic=true)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        this.verifyRegisteredServiceProperties(registeredService, service);
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            this.logger.info("Service ticket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        try {
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    this.logger.info("ServiceTicket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!serviceTicket.isValidFor(service)) {
                    this.logger.error("Service ticket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), service});
                    throw new UnrecognizableServiceForServiceTicketValidationException(serviceTicket.getService());
                }
            }
            TicketGrantingTicket root = serviceTicket.getGrantingTicket().getRoot();
            Authentication authentication = this.getAuthenticationSatisfiedByPolicy(root, new ServiceContext(serviceTicket.getService(), registeredService));
            Principal principal = authentication.getPrincipal();
            AttributeReleasePolicy attributePolicy = registeredService.getAttributeReleasePolicy();
            this.logger.debug("Attribute policy [{}] is associated with service [{}]", (Object)attributePolicy, (Object)registeredService);
            Map attributesToRelease = attributePolicy != null ? attributePolicy.getAttributes(principal) : Collections.EMPTY_MAP;
            String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service);
            Principal modifiedPrincipal = this.principalFactory.createPrincipal(principalId, attributesToRelease);
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance(authentication);
            builder.setPrincipal(modifiedPrincipal);
            ImmutableAssertion immutableAssertion = new ImmutableAssertion(builder.build(), serviceTicket.getGrantingTicket().getChainedAuthentications(), serviceTicket.getService(), serviceTicket.isFromNewLogin());
            return immutableAssertion;
        }
        finally {
            if (serviceTicket.isExpired()) {
                this.ticketRegistry.deleteTicket(serviceTicketId);
            }
        }
    }

    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="CREATE_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="CREATE_TICKET_GRANTING_TICKET_METER")
    @Counted(name="CREATE_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public TicketGrantingTicket createTicketGrantingTicket(Credential ... credentials) throws AuthenticationException, TicketException {
        Set<Credential> sanitizedCredentials = CentralAuthenticationServiceImpl.sanitizeCredentials(credentials);
        if (!sanitizedCredentials.isEmpty()) {
            Authentication authentication = this.authenticationManager.authenticate(credentials);
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
            this.ticketRegistry.addTicket((Ticket)ticketGrantingTicket);
            return ticketGrantingTicket;
        }
        String msg = "No credentials were specified in the request for creating a new ticket-granting ticket";
        this.logger.warn("No credentials were specified in the request for creating a new ticket-granting ticket");
        throw new TicketCreationException(new IllegalArgumentException("No credentials were specified in the request for creating a new ticket-granting ticket"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timed(name="GET_TICKET_TIMER")
    @Metered(name="GET_TICKET_METER")
    @Counted(name="GET_TICKET_COUNTER", monotonic=true)
    public <T extends Ticket> T getTicket(String ticketId, Class<? extends Ticket> clazz) throws InvalidTicketException {
        Assert.notNull((Object)ticketId, (String)"ticketId cannot be null");
        Ticket ticket = this.ticketRegistry.getTicket(ticketId, clazz);
        if (ticket == null) {
            this.logger.debug("Ticket [{}] by type [{}] cannot be found in the ticket registry.", (Object)ticketId, (Object)clazz.getSimpleName());
            throw new InvalidTicketException(ticketId);
        }
        if (ticket instanceof TicketGrantingTicket) {
            Ticket ticket2 = ticket;
            synchronized (ticket2) {
                if (ticket.isExpired()) {
                    this.ticketRegistry.deleteTicket(ticketId);
                    this.logger.debug("Ticket [{}] has expired and is now deleted from the ticket registry.", (Object)ticketId);
                    throw new InvalidTicketException(ticketId);
                }
            }
        }
        return (T)ticket;
    }

    @Timed(name="GET_TICKETS_TIMER")
    @Metered(name="GET_TICKETS_METER")
    @Counted(name="GET_TICKETS_COUNTER", monotonic=true)
    public Collection<Ticket> getTickets(Predicate predicate) {
        HashSet<Ticket> c = new HashSet<Ticket>(this.ticketRegistry.getTickets());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (predicate.apply(it.next())) continue;
            it.remove();
        }
        return c;
    }

    public void setServiceContextAuthenticationPolicyFactory(ContextualAuthenticationPolicyFactory<ServiceContext> policy) {
        this.serviceContextAuthenticationPolicyFactory = policy;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    @Deprecated
    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.logger.warn("setPersistentIdGenerator() is deprecated and no longer available. Consider configuring the an attribute provider for service definitions.");
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    private Authentication getAuthenticationSatisfiedByPolicy(TicketGrantingTicket ticket, ServiceContext context) throws TicketException {
        ContextualAuthenticationPolicy policy = this.serviceContextAuthenticationPolicyFactory.createPolicy((Object)context);
        if (policy.isSatisfiedBy(ticket.getAuthentication())) {
            this.logger.debug("Authentication policy {} is satisfied by the authentication associated with {}", (Object)policy, (Object)ticket.getId());
            return ticket.getAuthentication();
        }
        for (Authentication auth : ticket.getSupplementalAuthentications()) {
            if (!policy.isSatisfiedBy(auth)) continue;
            this.logger.debug("Authentication policy {} is satisfied by supplemental authentication associated with {}", (Object)policy, (Object)ticket.getId());
            return auth;
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }
}

