/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;

public class CollectionMapper<E, R>
extends AbstractCollection<R> {
    protected final Collection<E> realCollection;
    protected final Function<? super E, ? extends R> mapper;

    public CollectionMapper(Collection<E> realCollection, Function<? super E, ? extends R> mapper) {
        this.realCollection = realCollection;
        this.mapper = mapper;
    }

    @Override
    public int size() {
        return this.realCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.realCollection.isEmpty();
    }

    @Override
    public Iterator<R> iterator() {
        return new IteratorMapper<E, R>(this.realCollection.iterator(), this.mapper){

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public Spliterator<R> spliterator() {
        return new SpliteratorMapper(this.realCollection.spliterator(), this.mapper);
    }

    @Override
    public Stream<R> stream() {
        return this.realCollection.stream().map(this.mapper);
    }

    @Override
    public Stream<R> parallelStream() {
        return this.realCollection.parallelStream().map(this.mapper);
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        this.stream().forEach(action);
    }

    @Override
    public boolean add(R e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

