/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.IOUtils;

public class ZIPReader {
    private File zipFile;

    public ZIPReader(File inputStream) {
        this.zipFile = inputStream;
    }

    public List<String> ls() {
        ArrayList<String> name = new ArrayList<String>();
        ZipUtil.iterate((File)this.zipFile, (inputStream, zipEntry) -> name.add(zipEntry.getName()));
        return name;
    }

    public InputStream read(String entryName) {
        byte[] data = ZipUtil.unpackEntry((File)this.zipFile, (String)entryName);
        Objects.requireNonNull(data, entryName);
        return new ByteArrayInputStream(data);
    }

    public void unpack(String entryName, File to) throws IOException {
        ZipUtil.unpackEntry((File)this.zipFile, (String)entryName, (File)to);
    }

    public void unpack(File to) throws IOException {
        ZipUtil.unpack((File)this.zipFile, (File)to);
    }

    public void remove(String entryName) throws IOException {
        ZipUtil.removeEntry((File)this.zipFile, (String)entryName);
    }

    public void replace(String entryName, InputStream inputStream) throws IOException {
        ZipUtil.replaceEntry((File)this.zipFile, (String)entryName, (byte[])IOUtils.toByteArray((InputStream)inputStream));
    }
}

