/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.switcher;

import java.util.Deque;
import java.util.LinkedList;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.datasource.switcher.DataSourceSwitcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceSwitcher
implements DataSourceSwitcher {
    private static final String DEFAULT_DATASOURCE_ID = DataSourceSwitcher.class.getName() + "_default_";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private Deque<String> getUsedHistoryQueue() {
        return (Deque)ThreadLocalUtils.get((String)(DefaultDataSourceSwitcher.class.getName() + "_queue"), LinkedList::new);
    }

    @Override
    public void useLast() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return;
        }
        this.getUsedHistoryQueue().removeLast();
        if (this.logger.isDebugEnabled()) {
            String current = this.currentDataSourceId();
            if (null != current) {
                this.logger.debug("try use last data source : {}", (Object)this.currentDataSourceId());
            } else {
                this.logger.debug("try use last default data source");
            }
        }
    }

    @Override
    public void use(String dataSourceId) {
        this.getUsedHistoryQueue().addLast(dataSourceId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("try use data source : {}", (Object)dataSourceId);
        }
    }

    @Override
    public void useDefault() {
        this.getUsedHistoryQueue().addLast(DEFAULT_DATASOURCE_ID);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("try use default data source");
        }
    }

    @Override
    public String currentDataSourceId() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return null;
        }
        String activeId = this.getUsedHistoryQueue().getLast();
        if (DEFAULT_DATASOURCE_ID.equals(activeId)) {
            return null;
        }
        return activeId;
    }

    @Override
    public void reset() {
        this.getUsedHistoryQueue().clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reset data source used history");
        }
    }
}

