/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.strategy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.datasource.strategy.CachedDataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.DataSourceSwitchStrategyMatcher;
import org.springframework.util.AntPathMatcher;

public class ExpressionDataSourceSwitchStrategyMatcher
extends CachedDataSourceSwitchStrategyMatcher {
    private Map<String, ExpressionStrategy> switcher = new HashMap<String, ExpressionStrategy>();
    private static AntPathMatcher antPathMatcher = new AntPathMatcher(".");

    @Override
    public DataSourceSwitchStrategyMatcher.Strategy createStrategyIfMatch(Class target, Method method) {
        if (this.switcher.isEmpty()) {
            return null;
        }
        String text = target.getName().concat(".").concat(method.getName());
        return this.switcher.entrySet().stream().filter(entry -> antPathMatcher.match(((ExpressionStrategy)entry.getValue()).getExpression(), text)).peek(entry -> ((ExpressionStrategy)entry.getValue()).setId((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public Map<String, ExpressionStrategy> getSwitcher() {
        return this.switcher;
    }

    public void setSwitcher(Map<String, ExpressionStrategy> switcher) {
        this.switcher = switcher;
    }

    public static class ExpressionStrategy
    implements DataSourceSwitchStrategyMatcher.Strategy {
        private boolean useDefaultDataSource = false;
        private boolean fallbackDefault = false;
        private String dataSourceId = null;
        private String expression;
        private String id;

        @Override
        public boolean isUseDefaultDataSource() {
            return this.useDefaultDataSource && this.dataSourceId == null;
        }

        public String toString() {
            return "Expression Strategy(use(" + (this.isUseDefaultDataSource() ? "default" : this.getDataSourceId()) + "),expression:" + this.getExpression() + ")";
        }

        @Override
        public boolean isFallbackDefault() {
            return this.fallbackDefault;
        }

        @Override
        public String getDataSourceId() {
            return this.dataSourceId;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getId() {
            return this.id;
        }

        public void setUseDefaultDataSource(boolean useDefaultDataSource) {
            this.useDefaultDataSource = useDefaultDataSource;
        }

        public void setFallbackDefault(boolean fallbackDefault) {
            this.fallbackDefault = fallbackDefault;
        }

        public void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

