/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.executor.AbstractJdbcSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultJdbcExecutor
extends AbstractJdbcSqlExecutor {
    protected String getDatasourceId() {
        String id = DataSourceHolder.switcher().currentDataSourceId();
        return id == null ? "default" : id;
    }

    public Connection getConnection() {
        DataSource dataSource = DataSourceHolder.currentDataSource().getNative();
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        boolean isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DataSource ({}) JDBC Connection [{}] will {}be managed by Spring", new Object[]{this.getDatasourceId(), connection, isConnectionTransactional ? "" : "not "});
        }
        return connection;
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Releasing DataSource ({}) JDBC Connection [{}]", (Object)this.getDatasourceId(), (Object)connection);
        }
        try {
            DataSourceUtils.doReleaseConnection((Connection)connection, (DataSource)DataSourceHolder.currentDataSource().getNative());
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            try {
                connection.close();
            }
            catch (Exception e2) {
                this.logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @Transactional(readOnly=true)
    public <T> List<T> list(SQL sql, ObjectWrapper<T> wrapper) throws SQLException {
        return super.list(sql, wrapper);
    }

    @Transactional(readOnly=true)
    public void list(String sql, Object params, Consumer<Map<String, Object>> consumer) throws SQLException {
        super.list(sql, params, consumer);
    }

    @Transactional(readOnly=true)
    public void list(String sql, Consumer<Map<String, Object>> consumer) throws SQLException {
        super.list(sql, consumer);
    }

    @Transactional(readOnly=true)
    public <T> List<T> list(String sql, Object params, ObjectWrapper<T> wrapper) throws SQLException {
        return super.list(sql, params, wrapper);
    }

    @Transactional(readOnly=true)
    public <T> List<T> list(String sql, ObjectWrapper<T> wrapper) throws SQLException {
        return super.list(sql, wrapper);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> list(String sql) throws SQLException {
        return super.list(sql);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> list(SQL sql) throws SQLException {
        return super.list(sql);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> list(String sql, Object params) throws SQLException {
        return super.list(sql, params);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void exec(SQL sql) throws SQLException {
        super.exec(sql);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void exec(String sql) throws SQLException {
        super.exec(sql);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void exec(String sql, Object params) throws SQLException {
        super.exec(sql, params);
    }
}

