/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.ExpressionUtils;
import org.hswebframework.web.boost.aop.context.MethodInterceptorContext;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.exception.DataSourceNotFoundException;
import org.hswebframework.web.datasource.strategy.AnnotationDataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.CachedDataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.CachedTableSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.DataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.ExpressionDataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.TableSwitchStrategyMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
public class AopDataSourceSwitcherAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="hsweb.datasource")
    public ExpressionDataSourceSwitchStrategyMatcher expressionDataSourceSwitchStrategyMatcher() {
        return new ExpressionDataSourceSwitchStrategyMatcher();
    }

    @Bean
    public AnnotationDataSourceSwitchStrategyMatcher annotationDataSourceSwitchStrategyMatcher() {
        return new AnnotationDataSourceSwitchStrategyMatcher();
    }

    @Bean
    public TableSwitchStrategyMatcher alwaysNoMatchStrategyMatcher() {
        return new TableSwitchStrategyMatcher(){

            @Override
            public boolean match(Class target, Method method) {
                return false;
            }

            @Override
            public TableSwitchStrategyMatcher.Strategy getStrategy(MethodInterceptorContext context) {
                return null;
            }
        };
    }

    @Bean
    public SwitcherMethodMatcherPointcutAdvisor switcherMethodMatcherPointcutAdvisor(List<DataSourceSwitchStrategyMatcher> matchers, List<TableSwitchStrategyMatcher> tableSwitcher) {
        return new SwitcherMethodMatcherPointcutAdvisor(matchers, tableSwitcher);
    }

    public static class SwitcherMethodMatcherPointcutAdvisor
    extends StaticMethodMatcherPointcutAdvisor {
        private static final Logger logger = LoggerFactory.getLogger(SwitcherMethodMatcherPointcutAdvisor.class);
        private static final long serialVersionUID = 536295121851990398L;
        private List<DataSourceSwitchStrategyMatcher> matchers;
        private List<TableSwitchStrategyMatcher> tableSwitcher;
        private Map<CachedDataSourceSwitchStrategyMatcher.CacheKey, DataSourceSwitchStrategyMatcher> cache = new ConcurrentHashMap<CachedDataSourceSwitchStrategyMatcher.CacheKey, DataSourceSwitchStrategyMatcher>();
        private Map<CachedTableSwitchStrategyMatcher.CacheKey, TableSwitchStrategyMatcher> tableCache = new ConcurrentHashMap<CachedTableSwitchStrategyMatcher.CacheKey, TableSwitchStrategyMatcher>();

        public SwitcherMethodMatcherPointcutAdvisor(List<DataSourceSwitchStrategyMatcher> matchers, List<TableSwitchStrategyMatcher> tableSwitcher) {
            this.matchers = matchers;
            this.tableSwitcher = tableSwitcher;
            this.setAdvice((Advice)((MethodInterceptor)methodInvocation -> {
                CachedDataSourceSwitchStrategyMatcher.CacheKey key = new CachedDataSourceSwitchStrategyMatcher.CacheKey(ClassUtils.getUserClass((Object)methodInvocation.getThis()), methodInvocation.getMethod());
                CachedTableSwitchStrategyMatcher.CacheKey tableKey = new CachedTableSwitchStrategyMatcher.CacheKey(ClassUtils.getUserClass((Object)methodInvocation.getThis()), methodInvocation.getMethod());
                DataSourceSwitchStrategyMatcher matcher = this.cache.get(key);
                TableSwitchStrategyMatcher tableMatcher = this.tableCache.get(tableKey);
                Consumer<MethodInterceptorContext> before = context -> {};
                AtomicBoolean dataSourceChanged = new AtomicBoolean(true);
                if (matcher != null) {
                    before = before.andThen(context -> {
                        DataSourceSwitchStrategyMatcher.Strategy strategy = matcher.getStrategy((MethodInterceptorContext)context);
                        if (strategy == null) {
                            dataSourceChanged.set(false);
                            logger.warn("strategy matcher found:{}, but strategy is null!", (Object)matcher);
                            return;
                        }
                        logger.debug("switch datasource.use strategy:{}", (Object)strategy);
                        if (strategy.isUseDefaultDataSource()) {
                            DataSourceHolder.switcher().useDefault();
                            return;
                        }
                        try {
                            String id = strategy.getDataSourceId();
                            if (id.contains("${")) {
                                id = ExpressionUtils.analytical((String)id, (Map)context.getParams(), (String)"spel");
                            }
                            if (!DataSourceHolder.existing(id)) {
                                if (!strategy.isFallbackDefault()) throw new DataSourceNotFoundException(id);
                                DataSourceHolder.switcher().useDefault();
                                return;
                            } else {
                                DataSourceHolder.switcher().use(id);
                            }
                            return;
                        }
                        catch (RuntimeException e) {
                            dataSourceChanged.set(false);
                            throw e;
                        }
                        catch (Exception e) {
                            dataSourceChanged.set(false);
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    });
                }
                if (tableMatcher != null) {
                    before = before.andThen(context -> {
                        TableSwitchStrategyMatcher.Strategy strategy = tableMatcher.getStrategy((MethodInterceptorContext)context);
                        if (null != strategy) {
                            logger.debug("switch table. use strategy:{}", (Object)strategy);
                            strategy.getMapping().forEach(DataSourceHolder.tableSwitcher()::use);
                        } else {
                            logger.warn("table strategy matcher found:{}, but strategy is null!", (Object)matcher);
                        }
                    });
                }
                MethodInterceptorHolder holder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
                before.accept(holder.createParamContext());
                try {
                    Object object = methodInvocation.proceed();
                    return object;
                }
                finally {
                    if (dataSourceChanged.get()) {
                        DataSourceHolder.switcher().useLast();
                    }
                    DataSourceHolder.tableSwitcher().reset();
                }
            }));
        }

        public boolean matches(Method method, Class<?> aClass) {
            Class targetClass = ClassUtils.getUserClass(aClass);
            CachedDataSourceSwitchStrategyMatcher.CacheKey key = new CachedDataSourceSwitchStrategyMatcher.CacheKey(targetClass, method);
            this.matchers.stream().filter(matcher -> matcher.match(targetClass, method)).findFirst().ifPresent(matcher -> this.cache.put(key, (DataSourceSwitchStrategyMatcher)matcher));
            boolean datasourceMatched = this.cache.containsKey(key);
            boolean tableMatched = false;
            if (null != this.tableSwitcher) {
                CachedTableSwitchStrategyMatcher.CacheKey tableCacheKey = new CachedTableSwitchStrategyMatcher.CacheKey(targetClass, method);
                this.tableSwitcher.stream().filter(matcher -> matcher.match(targetClass, method)).findFirst().ifPresent(matcher -> this.tableCache.put(tableCacheKey, (TableSwitchStrategyMatcher)matcher));
                tableMatched = this.tableCache.containsKey(tableCacheKey);
            }
            return datasourceMatched || tableMatched;
        }
    }
}

