/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.validator;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.web.validator.DuplicateKeyException;

public interface LogicPrimaryKeyValidator {
    public <T> Result<T> validate(T var1, Class ... var2);

    public static class Result<T> {
        private boolean error = false;
        private T data;
        private Map<String, Object> properties;
        private String message = "\u5b58\u5728\u76f8\u540c\u6570\u636e";

        public static Result passed() {
            Result result = new Result();
            result.setError(false);
            return result;
        }

        public boolean isPassed() {
            return !this.error;
        }

        public void ifPassed(Consumer<Result<T>> consumer) {
            if (this.isPassed()) {
                consumer.accept(this);
            }
        }

        public void ifError(Consumer<Result<T>> consumer) {
            if (this.isError()) {
                consumer.accept(this);
            }
        }

        public void ifErrorThrow() {
            this.ifErrorThrow(DuplicateKeyException::new);
        }

        public void ifErrorThrow(Function<Result<T>, Exception> exceptionGetter) {
            if (this.isError()) {
                throw exceptionGetter.apply(this);
            }
        }

        public boolean isError() {
            return this.error;
        }

        public T getData() {
            return this.data;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public String getMessage() {
            return this.message;
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public void setData(T data) {
            this.data = data;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

