/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dict.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.dict.ClassDictDefine;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dict.defaults.DefaultClassDictDefine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDictDefineRepository
implements DictDefineRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultDictDefineRepository.class);
    protected static final Map<String, DictDefine> parsedDict = new HashMap<String, DictDefine>();

    public static void registerDefine(DictDefine define) {
        parsedDict.put(define.getId(), define);
    }

    public static <T extends Enum> ClassDictDefine parseEnumDict(Class<T> type) {
        log.debug("parse enum dict :{}", type);
        Dict dict = type.getAnnotation(Dict.class);
        DefaultClassDictDefine define = new DefaultClassDictDefine();
        define.setField("");
        if (dict != null) {
            define.setId(dict.id());
            define.setParserId(dict.parserId());
            define.setComments(dict.comments());
            define.setAlias(dict.alias());
        } else {
            define.setId(type.getSimpleName());
            define.setAlias(type.getName());
            define.setComments(type.getSimpleName());
        }
        List<T> dicts = Arrays.asList(type.getEnumConstants());
        define.setItems(new ArrayList<EnumDict<Object>>(dicts));
        return define;
    }

    @Override
    public DictDefine getDefine(String id) {
        return parsedDict.get(id);
    }

    @Override
    public List<DictDefine> getAllDefine() {
        return new ArrayList<DictDefine>(parsedDict.values());
    }

    @Override
    public List<ClassDictDefine> getDefine(Class type) {
        return new ArrayList<ClassDictDefine>();
    }

    @Override
    public void addDefine(DictDefine dictDefine) {
        DefaultDictDefineRepository.registerDefine(dictDefine);
    }
}

