/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dict.apply;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dict.apply.DictApply;
import org.hswebframework.web.dict.apply.DictWrapper;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultDictApply
implements DictApply {
    private DictDefineRepository repository;
    protected Map<Class, DictWrapper> cache = new ConcurrentHashMap<Class, DictWrapper>();

    @Override
    public <T> T apply(T bean) {
        this.cache.computeIfAbsent(ClassUtils.getUserClass(bean.getClass()), this::createCache).wrap(bean, this.repository);
        return bean;
    }

    protected DictWrapper createCache(Class bean) {
        StringBuilder method = new StringBuilder().append("public void wrap(Object bean, org.hswebframework.web.dict.DictDefineRepository repository)").append("{\n").append(bean.getName()).append(" target=(").append(bean.getName()).append(")bean;\n");
        ReflectionUtils.doWithFields((Class)bean, field -> {
            Class<?> type = field.getType();
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (!type.isEnum() || !EnumDict.class.isAssignableFrom(type) || type.getEnumConstants().length >= 64) {
                // empty if block
            }
        });
        method.append("\n}");
        return DictWrapper.empty;
    }
}

