/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dict;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

@JSONType(deserializer=EnumDictJSONDeserializer.class)
public interface EnumDict<V>
extends JSONSerializable {
    public static final boolean DEFAULT_WRITE_JSON_OBJECT = !Boolean.getBoolean("hsweb.enum.dict.disableWriteJSONObject");

    public V getValue();

    public String getText();

    public int ordinal();

    default public long index() {
        return this.ordinal();
    }

    default public long getMask() {
        return 1L << (int)this.index();
    }

    default public boolean eq(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Object[]) {
            v = Arrays.asList(v);
        }
        if (v instanceof Collection) {
            return ((Collection)v).stream().anyMatch(this::eq);
        }
        if (v instanceof Map) {
            v = ((Map)((Object)v)).getOrDefault("value", ((Map)((Object)v)).get("text"));
        }
        return this == v || this.getValue() == v || this.getValue().equals(v) || v instanceof Number && this.in(((Number)((Object)v)).longValue()) || String.valueOf(this.getValue()).equalsIgnoreCase(String.valueOf(v)) || ((Object)v).equals(this.getMask()) || this.getText().equalsIgnoreCase(String.valueOf(v));
    }

    default public boolean in(long mask) {
        return (mask & this.getMask()) != 0L;
    }

    default public boolean in(EnumDict<V> ... dict) {
        return this.in(EnumDict.toMask((EnumDict[])dict));
    }

    default public String getComments() {
        return this.getText();
    }

    public static <T extends Enum> Optional<T> find(Class<T> type, Predicate<T> predicate) {
        if (type.isEnum()) {
            for (Enum enumDict : (Enum[])type.getEnumConstants()) {
                if (!predicate.test(enumDict)) continue;
                return Optional.of(enumDict);
            }
        }
        return Optional.empty();
    }

    public static <T extends Enum> Optional<T> findByValue(Class<T> type, Object value) {
        return EnumDict.find(type, (T e) -> ((EnumDict)((Object)e)).getValue() == value || ((EnumDict)((Object)e)).getValue().equals(value) || String.valueOf(((EnumDict)((Object)e)).getValue()).equalsIgnoreCase(String.valueOf(value)));
    }

    public static <T extends Enum> Optional<T> findByText(Class<T> type, String text) {
        return EnumDict.find(type, (T e) -> ((EnumDict)((Object)e)).getText().equalsIgnoreCase(text));
    }

    public static <T extends Enum> Optional<T> find(Class<T> type, Object target) {
        return EnumDict.find(type, (T v) -> ((EnumDict)((Object)v)).eq(target));
    }

    @SafeVarargs
    public static <T extends EnumDict> long toMask(T ... t) {
        if (t == null) {
            return 0L;
        }
        long value = 0L;
        for (T t1 : t) {
            value |= t1.getMask();
        }
        return value;
    }

    @SafeVarargs
    public static <T extends Enum> boolean in(T target, T ... t) {
        Enum[] all = (Enum[])target.getClass().getEnumConstants();
        if (all.length >= 64) {
            List<T> list = Arrays.asList(t);
            return Arrays.stream(all).map(EnumDict.class::cast).anyMatch(list::contains);
        }
        return EnumDict.maskIn((long)EnumDict.toMask((EnumDict[])((EnumDict[])t)), (EnumDict[])new Enum[]{target});
    }

    @SafeVarargs
    public static <T extends EnumDict> boolean maskIn(long mask, T ... t) {
        long value = EnumDict.toMask(t);
        return (mask & value) == value;
    }

    @SafeVarargs
    public static <T extends EnumDict> boolean maskInAny(long mask, T ... t) {
        long value = EnumDict.toMask(t);
        return (mask & value) != 0L;
    }

    public static <T extends EnumDict> List<T> getByMask(List<T> allOptions, long mask) {
        if (allOptions.size() >= 64) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u9009\u9879\u8d85\u8fc764\u4e2a\u6570\u636e\u5b57\u5178!");
        }
        ArrayList<EnumDict> arr = new ArrayList<EnumDict>();
        List<T> all = allOptions;
        for (EnumDict t : all) {
            if (!t.in(mask)) continue;
            arr.add(t);
        }
        return arr;
    }

    public static <T extends EnumDict> List<T> getByMask(Supplier<List<T>> allOptionsSupplier, long mask) {
        return EnumDict.getByMask(allOptionsSupplier.get(), mask);
    }

    public static <T extends Enum> List<T> getByMask(Class<T> tClass, long mask) {
        return EnumDict.getByMask(Arrays.asList(tClass.getEnumConstants()), mask);
    }

    default public boolean isWriteJSONObjectEnabled() {
        return DEFAULT_WRITE_JSON_OBJECT;
    }

    default public Object getWriteJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", this.getValue());
        jsonObject.put("text", (Object)this.getText());
        jsonObject.put("index", (Object)this.index());
        jsonObject.put("mask", (Object)this.getMask());
        return jsonObject;
    }

    default public void write(JSONSerializer jsonSerializer, Object o, Type type, int i) throws IOException {
        if (this.isWriteJSONObjectEnabled()) {
            jsonSerializer.write(this.getWriteJSONObject());
        } else {
            jsonSerializer.write(this.getValue());
        }
    }

    public static class EnumDictJSONDeserializer
    implements ObjectDeserializer {
        public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            try {
                JSONLexer lexer = parser.lexer;
                int token = lexer.token();
                if (token == 2) {
                    int intValue = lexer.intValue();
                    lexer.nextToken(16);
                    return (T)EnumDict.find((Class)type, intValue);
                }
                if (token == 4) {
                    String name = lexer.stringVal();
                    lexer.nextToken(16);
                    if (name.length() == 0) {
                        return null;
                    }
                    return EnumDict.find((Class)type, name).orElse(null);
                }
                if (token == 8) {
                    lexer.nextToken(16);
                    return null;
                }
                Object value = parser.parse();
                if (value instanceof Map) {
                    return (T)EnumDict.find((Class)type, ((Map)value).get("value")).orElseGet(() -> EnumDict.find((Class)type, ((Map)value).get("text")).orElse(null));
                }
                throw new JSONException("parse enum " + type + " error, value : " + value);
            }
            catch (JSONException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), (Throwable)e);
            }
        }

        public int getFastMatchToken() {
            return 4;
        }
    }
}

