/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.util.Set;
import java.util.function.Supplier;
import javax.validation.ConstraintViolation;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.service.CreateEntityService;
import org.hswebframework.web.service.Service;
import org.hswebframework.web.service.Validator;
import org.hswebframework.web.validate.SimpleValidateResults;
import org.hswebframework.web.validate.ValidateResults;
import org.hswebframework.web.validate.ValidationException;
import org.hswebframework.web.validator.LogicPrimaryKeyValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractService<E extends Entity, PK>
implements CreateEntityService<E>,
Service {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected javax.validation.Validator validator;
    protected EntityFactory entityFactory;
    protected LogicPrimaryKeyValidator logicPrimaryKeyValidator;
    protected Class<E> entityType;
    protected Class<PK> primaryKeyType = ClassUtils.getGenericType(this.getClass(), (int)1);

    @Autowired(required=false)
    public void setValidator(javax.validation.Validator validator) {
        this.validator = validator;
    }

    @Autowired(required=false)
    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    @Autowired(required=false)
    public void setLogicPrimaryKeyValidator(LogicPrimaryKeyValidator logicPrimaryKeyValidator) {
        this.logicPrimaryKeyValidator = logicPrimaryKeyValidator;
    }

    public AbstractService() {
        this.entityType = ClassUtils.getGenericType(this.getClass(), (int)0);
    }

    protected boolean entityFactoryIsEnabled() {
        if (this.entityFactory == null) {
            this.logger.warn("entityFactory is null!");
        }
        return null != this.entityFactory;
    }

    public Class<E> getEntityInstanceType() {
        return this.entityFactory.getInstanceType(this.getEntityType());
    }

    public Class<E> getEntityType() {
        return this.entityType;
    }

    protected Class<PK> getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    public E createEntity() {
        if (!this.entityFactoryIsEnabled()) {
            throw new UnsupportedOperationException("{unsupported_operation}");
        }
        return (E)((Entity)this.entityFactory.newInstance(this.getEntityType()));
    }

    protected <T> void tryValidateProperty(Validator<T> validator, String property, T value) {
        if (validator != null && !validator.validate(value)) {
            throw new ValidationException(validator.getErrorMessage(), property);
        }
    }

    protected <T> void tryValidateProperty(Validator<T> validator, String property, T value, String message) {
        if (validator != null && !validator.validate(value)) {
            throw new ValidationException(message, property);
        }
    }

    protected void tryValidateProperty(boolean success, String property, String message) {
        if (!success) {
            throw new ValidationException(message, property);
        }
    }

    protected void tryValidate(Object data, String property, Class ... groups) {
        this.validate(() -> this.validator.validateProperty(data, property, groups));
    }

    protected <T> void tryValidate(Class<T> type, String property, Object value, Class ... groups) {
        this.validate(() -> this.validator.validateValue(type, property, value, groups));
    }

    protected void tryValidate(Object data, Class ... groups) {
        this.validate(() -> this.validator.validate(data, groups));
    }

    private <T> void validate(Supplier<Set<ConstraintViolation<T>>> validatorSetFunction) {
        if (this.validator == null) {
            this.logger.warn("validator is null!");
            return;
        }
        SimpleValidateResults results = new SimpleValidateResults();
        validatorSetFunction.get().forEach(violation -> results.addResult(violation.getPropertyPath().toString(), violation.getMessage()));
        if (!results.isSuccess()) {
            throw new ValidationException((ValidateResults)results);
        }
    }

    public static void assertNotNull(Object data) {
        AbstractService.assertNotNull(data, "{data_not_found}");
    }

    public static void assertNotNull(Object data, String message) {
        if (null == data) {
            throw new NotFoundException(message);
        }
    }
}

