/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.commons.entity.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.commons.entity.QueryEntity;
import org.hswebframework.web.commons.entity.param.TermExpressionParser;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class QueryParamEntity
extends QueryParam
implements QueryEntity {
    private static final long serialVersionUID = 8097500947924037523L;
    private String termExpression;

    public static QueryParamEntity empty() {
        return new QueryParamEntity();
    }

    public static QueryParamEntity single(String field, Object value) {
        return QueryParamEntity.of(field, value);
    }

    public static QueryParamEntity of(String field, Object value) {
        return (QueryParamEntity)QueryParamEntity.empty().where(field, value);
    }

    public static <T> Query<T, QueryParamEntity> newQuery() {
        return Query.empty((QueryParam)new QueryParamEntity());
    }

    public <T> Query<T, QueryParamEntity> toQuery() {
        return Query.empty((QueryParam)this);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery() {
        return this.toNestQuery(null);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery(Consumer<Query<T, QueryParamEntity>> before) {
        List<Term> terms = this.getTerms();
        this.setTerms(new ArrayList());
        Query<T, QueryParamEntity> query = this.toQuery();
        if (null != before) {
            before.accept(query);
        }
        return (Query)((NestConditional)query.nest().each(terms, NestConditional::accept)).end();
    }

    public void setTermExpression(String termExpression) {
        this.termExpression = termExpression;
        this.setTerms(TermExpressionParser.parse(termExpression));
    }

    public List<Term> getTerms() {
        List<Term> terms = super.getTerms();
        if (CollectionUtils.isEmpty((Collection)terms) && StringUtils.hasText((String)this.termExpression)) {
            terms = TermExpressionParser.parse(this.termExpression);
            this.setTerms(terms);
        }
        return terms;
    }

    public String toString() {
        return this.toHttpQueryParamString();
    }

    public QueryParamEntity noPaging() {
        this.setPaging(false);
        return this;
    }

    public String getTermExpression() {
        return this.termExpression;
    }
}

