/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.commons.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.SortSupportEntity;
import org.hswebframework.web.id.IDGenerator;

public interface TreeSupportEntity<PK>
extends GenericEntity<PK> {
    public static final String id = "id";
    public static final String path = "path";
    public static final String parentId = "parentId";

    public String getPath();

    public void setPath(String var1);

    public PK getParentId();

    public void setParentId(PK var1);

    public Integer getLevel();

    public void setLevel(Integer var1);

    public <T extends TreeSupportEntity<PK>> List<T> getChildren();

    public static String getParentPath(String path) {
        if (path == null || path.length() < 4) {
            return null;
        }
        return path.substring(0, path.length() - 5);
    }

    public static <T extends TreeSupportEntity> void forEach(Collection<T> list, Consumer<T> consumer) {
        list.forEach(node -> {
            consumer.accept(node);
            if (node.getChildren() != null) {
                TreeSupportEntity.forEach(node.getChildren(), consumer);
            }
        });
    }

    public static <T extends TreeSupportEntity<PK>, PK> void expandTree2List(T parent, List<T> target, IDGenerator<PK> idGenerator) {
        TreeSupportEntity.expandTree2List(parent, target, idGenerator, null);
    }

    public static <T extends TreeSupportEntity<PK>, PK> void expandTree2List(T parent, List<T> target, IDGenerator<PK> idGenerator, BiConsumer<T, List<T>> childConsumer) {
        List<T> children = parent.getChildren();
        if (childConsumer != null) {
            childConsumer.accept(parent, new ArrayList());
        }
        target.add(parent);
        if (parent.getPath() == null) {
            Long index;
            parent.setPath(RandomUtil.randomChar((int)4));
            if (parent.getPath() != null) {
                parent.setLevel(parent.getPath().split("-").length);
            }
            if (parent instanceof SortSupportEntity && null == (index = ((SortSupportEntity)((Object)parent)).getSortIndex())) {
                ((SortSupportEntity)((Object)parent)).setSortIndex(1L);
            }
        }
        if (children != null) {
            Object pid = parent.getId();
            if (pid == null) {
                pid = idGenerator.generate();
                parent.setId(pid);
            }
            for (int i = 0; i < children.size(); ++i) {
                TreeSupportEntity child = (TreeSupportEntity)children.get(i);
                if (child instanceof SortSupportEntity && parent instanceof SortSupportEntity) {
                    Long index = ((SortSupportEntity)((Object)parent)).getSortIndex();
                    if (null == index) {
                        index = 1L;
                        ((SortSupportEntity)((Object)parent)).setSortIndex(index);
                    }
                    ((SortSupportEntity)((Object)child)).setSortIndex(new BigDecimal(index + "0" + (i + 1)).longValue());
                }
                child.setParentId(pid);
                child.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4));
                child.setLevel(child.getPath().split("-").length);
                TreeSupportEntity.expandTree2List(child, target, idGenerator, childConsumer);
            }
        }
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer) {
        return TreeSupportEntity.list2tree(dataList, childConsumer, (TreeHelper<N, PK> predicate) -> node -> node == null || predicate.getNode(node.getParentId()) == null);
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer, Predicate<N> rootNodePredicate) {
        return TreeSupportEntity.list2tree(dataList, childConsumer, (TreeHelper<N, PK> predicate) -> rootNodePredicate);
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer, Function<TreeHelper<N, PK>, Predicate<N>> predicateFunction) {
        Objects.requireNonNull(dataList, "source list can not be null");
        Objects.requireNonNull(childConsumer, "child consumer can not be null");
        Objects.requireNonNull(predicateFunction, "root predicate function can not be null");
        Supplier<Stream> streamSupplier = () -> dataList.size() < 1000 ? dataList.stream() : dataList.parallelStream();
        final HashMap cache = new HashMap();
        final Map<Object, List<TreeSupportEntity>> treeCache = streamSupplier.get().peek(node -> cache.put(node.getId(), node)).collect(Collectors.groupingBy(TreeSupportEntity::getParentId));
        Predicate<N> rootNodePredicate = predicateFunction.apply(new TreeHelper<N, PK>(){

            @Override
            public List<N> getChildren(PK parentId) {
                return (List)treeCache.get(parentId);
            }

            @Override
            public N getNode(PK id) {
                return (TreeSupportEntity)cache.get(id);
            }
        });
        return streamSupplier.get().peek(node -> childConsumer.accept((Object)node, (List)treeCache.get(node.getId()))).filter(rootNodePredicate).collect(Collectors.toList());
    }

    public static interface TreeHelper<T, PK> {
        public List<T> getChildren(PK var1);

        public T getNode(PK var1);
    }
}

