/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.commons.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hswebframework.web.bean.ToString;
import org.hswebframework.web.commons.entity.CloneableEntity;

public interface GenericEntity<PK>
extends CloneableEntity {
    public static final String id = "id";
    public static final String properties = "properties";

    public PK getId();

    public void setId(PK var1);

    default public String toString(String ... ignoreProperty) {
        return ToString.toString((Object)this, (String[])ignoreProperty);
    }

    default public Map<String, Object> getProperties() {
        return null;
    }

    default public void setProperties(Map<String, Object> properties) {
    }

    default public <T> T getProperty(String propertyName, T defaultValue) {
        Map<String, Object> map = this.getProperties();
        if (map == null) {
            return null;
        }
        return (T)map.getOrDefault(propertyName, defaultValue);
    }

    default public <T> T getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    default public void setProperty(String propertyName, Object value) {
        Map<String, Object> map = this.getProperties();
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.setProperties(map);
        }
        map.put(propertyName, value);
    }

    default public Map<String, Object> cloneProperties() {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        Map<String, Object> old = this.getProperties();
        if (old == null || old.isEmpty()) {
            return target;
        }
        old.forEach((k, v) -> {
            if (v instanceof CloneableEntity) {
                target.put((String)k, ((CloneableEntity)v).clone());
            } else {
                target.put((String)k, v);
            }
        });
        return target;
    }
}

