/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.plgins.pager;

import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.dao.mybatis.builder.EasyOrmSqlBuilder;
import org.hswebframework.web.dao.mybatis.plgins.pager.Pager;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
@Component
public class PagerInterceptor
implements Interceptor {
    public Object intercept(Invocation target) throws Throwable {
        return target.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)target;
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            String sql = statementHandler.getBoundSql().getSql();
            Pager pager = Pager.getAndReset();
            String newSql = sql;
            if (sql.trim().toLowerCase().startsWith("select")) {
                Object queryEntity;
                if (pager != null) {
                    newSql = EasyOrmSqlBuilder.getInstance().getActiveDatabase().getDialect().doPaging(sql, pager.pageIndex(), pager.pageSize());
                }
                if ((queryEntity = statementHandler.getParameterHandler().getParameterObject()) instanceof QueryParam && ((QueryParam)queryEntity).isForUpdate()) {
                    newSql = newSql + " for update";
                }
                metaStatementHandler.setValue("delegate.boundSql.sql", (Object)newSql);
            }
        }
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

