/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.plgins.pager;

import org.hswebframework.web.ThreadLocalUtils;

public interface Pager {
    public static final String threadLocalKey = "nowPager";

    public int pageIndex();

    public int pageSize();

    public static Pager getAndReset() {
        try {
            Pager pager = Pager.get();
            return pager;
        }
        finally {
            Pager.reset();
        }
    }

    public static Pager get() {
        return (Pager)ThreadLocalUtils.get((String)threadLocalKey);
    }

    public static void reset() {
        ThreadLocalUtils.remove((String)threadLocalKey);
    }

    public static void doPaging(final int pageIndex, final int pageSize) {
        ThreadLocalUtils.put((String)threadLocalKey, (Object)new Pager(){

            @Override
            public int pageIndex() {
                return pageIndex;
            }

            @Override
            public int pageSize() {
                return pageSize;
            }
        });
    }

    public static void doPaging(int pageIndex, int pageSize, int total) {
        Pager.doPaging(pageIndex, pageSize);
        Pager.rePaging(total);
    }

    public static void rePaging(int total) {
        Pager pager = Pager.get();
        int pageIndex = 0;
        if (pager != null) {
            if (pager.pageIndex() != 0 && pager.pageIndex() * pager.pageSize() >= total) {
                int tmp = total / pager.pageSize();
                pageIndex = total % pager.pageSize() == 0 ? tmp - 1 : tmp;
            }
            Pager.doPaging(pageIndex, pager.pageSize());
        }
    }
}

