/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.mapper.dict;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hswebframework.ezorm.core.OptionConverter;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.hswebframework.web.dao.mybatis.mapper.AbstractSqlTermCustomizer;
import org.hswebframework.web.dao.mybatis.mapper.ChangedTermValue;
import org.hswebframework.web.dict.EnumDict;

public class DictTermTypeMapper
extends AbstractSqlTermCustomizer {
    private boolean not;

    public DictTermTypeMapper(boolean not) {
        super(not ? "not" : "eq");
        this.not = not;
    }

    private boolean support(RDBColumnMetaData column) {
        if (column.getJdbcType() == JDBCType.VARCHAR) {
            return false;
        }
        Class<?> type = column.getJavaType();
        if (type != null && type.isArray()) {
            type = type.getComponentType();
        }
        return type != null && type.isEnum() && EnumDict.class.isAssignableFrom(type) && column.getJavaType().isArray() || column.getProperty("dict-mask").isTrue() && column.getOptionConverter() != null;
    }

    private List<EnumDict> getAllOption(RDBColumnMetaData column) {
        OptionConverter converter;
        Class<?> type = column.getJavaType();
        if (null != type) {
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (type.isEnum() && EnumDict.class.isAssignableFrom(type)) {
                return Arrays.asList(type.getEnumConstants());
            }
        }
        if ((converter = column.getOptionConverter()) == null) {
            return new ArrayList<EnumDict>();
        }
        return (List)converter.getOptions();
    }

    public SqlAppender accept(String wherePrefix, Term term, RDBColumnMetaData column, String tableAlias) {
        if (!this.support(column)) {
            return this.buildNotSupport(wherePrefix, term, column, tableAlias);
        }
        ChangedTermValue changedValue = this.createChangedTermValue(term);
        List list = BoostTermTypeMapper.convertList((RDBColumnMetaData)column, (Object)changedValue.getOld());
        EnumDict[] dicts = (EnumDict[])this.getAllOption(column).stream().filter(d -> d.eq((Object)list)).toArray(EnumDict[]::new);
        changedValue.setValue(EnumDict.toMask((EnumDict[])dicts));
        Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
        String columnName = dialect.buildColumnName(tableAlias, column.getName());
        return new SqlAppender().add(new Object[]{columnName, this.not ? " != " : "=", "#{", wherePrefix, ".value.value}"});
    }

    protected SqlAppender buildNotSupport(String wherePrefix, Term term, RDBColumnMetaData column, String tableAlias) {
        ChangedTermValue termValue = this.createChangedTermValue(term);
        Object newValue = BoostTermTypeMapper.convertValue((RDBColumnMetaData)column, (Object)termValue.getOld());
        termValue.setValue(newValue);
        Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
        String columnName = dialect.buildColumnName(tableAlias, column.getName());
        SqlAppender appender = new SqlAppender();
        appender.add(new Object[]{columnName, this.not ? " != " : "=", "#{", wherePrefix, ".value.value}"});
        return appender;
    }
}

