/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.mapper.dict;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hswebframework.ezorm.core.OptionConverter;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.RenderPhase;
import org.hswebframework.ezorm.rdb.render.dialect.function.SqlFunction;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.hswebframework.web.dao.mybatis.mapper.AbstractSqlTermCustomizer;
import org.hswebframework.web.dao.mybatis.mapper.ChangedTermValue;
import org.hswebframework.web.dict.EnumDict;

public class DictInTermTypeMapper
extends AbstractSqlTermCustomizer {
    private boolean not;
    public static final String USE_DICT_MASK_FLAG = "dict-mask";

    public DictInTermTypeMapper(boolean not) {
        super(not ? "nin" : "in");
        this.not = not;
    }

    private boolean support(RDBColumnMetaData column) {
        if (column.getJdbcType() == JDBCType.VARCHAR) {
            return false;
        }
        Class<?> type = column.getJavaType();
        if (type != null && type.isArray()) {
            type = type.getComponentType();
        }
        return type != null && type.isEnum() && EnumDict.class.isAssignableFrom(type) && column.getJavaType().isArray() || column.getProperty(USE_DICT_MASK_FLAG).isTrue() && column.getOptionConverter() != null;
    }

    private List<EnumDict> getAllOption(RDBColumnMetaData column) {
        OptionConverter converter;
        Class<?> type = column.getJavaType();
        if (null != type) {
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (type.isEnum() && EnumDict.class.isAssignableFrom(type)) {
                return Arrays.asList(type.getEnumConstants());
            }
        }
        if ((converter = column.getOptionConverter()) == null) {
            return new ArrayList<EnumDict>();
        }
        return (List)converter.getOptions();
    }

    public SqlAppender accept(String wherePrefix, Term term, RDBColumnMetaData column, String tableAlias) {
        if (!this.support(column)) {
            return this.buildNotSupport(wherePrefix, term, column, tableAlias);
        }
        ChangedTermValue changedValue = this.createChangedTermValue(term);
        boolean any = term.getOptions().contains("any");
        List list = BoostTermTypeMapper.convertList((RDBColumnMetaData)column, (Object)changedValue.getOld());
        EnumDict[] dicts = (EnumDict[])this.getAllOption(column).stream().filter(d -> d.eq((Object)list)).toArray(EnumDict[]::new);
        changedValue.setValue(EnumDict.toMask((EnumDict[])dicts));
        Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
        String columnName = dialect.buildColumnName(tableAlias, column.getName());
        String where = "#{" + wherePrefix + ".value.value}";
        SqlFunction sqlFunction = dialect.getFunction("bitand");
        if (sqlFunction == null) {
            throw new UnsupportedOperationException("\u6570\u636e\u5e93\u4e0d\u652f\u6301[BITAND]\u51fd\u6570");
        }
        String bitAnd = sqlFunction.apply(SqlFunction.Param.of((RenderPhase)RenderPhase.where, Arrays.asList(columnName, where)));
        String n = any ? (this.not ? "=" : "!=") : (this.not ? "!=" : "=");
        return new SqlAppender().add(new Object[]{bitAnd, n, any ? "0" : columnName});
    }

    protected SqlAppender buildNotSupport(String wherePrefix, Term term, RDBColumnMetaData column, String tableAlias) {
        ChangedTermValue changedValue = this.createChangedTermValue(term);
        Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
        List values = BoostTermTypeMapper.convertList((RDBColumnMetaData)column, (Object)changedValue.getOld());
        changedValue.setValue(values);
        String columnName = dialect.buildColumnName(tableAlias, column.getName());
        SqlAppender appender = new SqlAppender();
        appender.add(new Object[]{columnName, this.not ? " NOT " : " "}).add((Object)"IN(");
        for (int i = 0; i < values.size(); ++i) {
            appender.add(new Object[]{"#{", wherePrefix, ".value.value[", i, "]}", ","});
        }
        appender.removeLast();
        appender.add((Object)")");
        return appender;
    }
}

