/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Alias(value="jsonSetHandler")
@MappedTypes(value={Set.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.CLOB})
public class JsonSetHandler
extends BaseTypeHandler<Set> {
    private static final Logger log = LoggerFactory.getLogger(JsonSetHandler.class);

    private Set<Object> parseSet(String json) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        return (Set)JSON.parseObject((String)json, Set.class);
    }

    public Set getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseSet(rs.getString(columnIndex));
    }

    public Set getResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseSet(rs.getString(columnName));
    }

    public Set getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseSet(cs.getString(columnIndex));
    }

    public void setParameter(PreparedStatement ps, int i, Set parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JSON.toJSONString((Object)parameter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Set parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, "[]");
    }

    public Set getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return new HashSet();
    }

    public Set getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return new HashSet();
    }

    public Set getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return new HashSet();
    }
}

