/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Alias(value="jsonMapHandler")
@MappedTypes(value={Map.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.CLOB})
public class JsonMapHandler
extends BaseTypeHandler<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(JsonMapHandler.class);

    private Map<String, Object> parseObject(String json) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        return JSON.parseObject((String)json);
    }

    public Map<String, Object> getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseObject(rs.getString(columnIndex));
    }

    public Map<String, Object> getResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseObject(rs.getString(columnName));
    }

    public Map<String, Object> getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseObject(cs.getString(columnIndex));
    }

    public void setParameter(PreparedStatement ps, int i, Map<String, Object> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JSON.toJSONString(parameter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Map<String, Object> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, "{}");
    }

    public Map<String, Object> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return new HashMap<String, Object>();
    }
}

