/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Alias(value="jsonArrayHandler")
@MappedTypes(value={List.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.CLOB})
public class JsonArrayHandler
extends BaseTypeHandler<List<Object>> {
    private static final Logger log = LoggerFactory.getLogger(JsonArrayHandler.class);

    private List<Object> parseArray(String json) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        return JSON.parseArray((String)json);
    }

    public List<Object> getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseArray(rs.getString(columnIndex));
    }

    public List<Object> getResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseArray(rs.getString(columnName));
    }

    public List<Object> getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseArray(cs.getString(columnIndex));
    }

    public void setParameter(PreparedStatement ps, int i, List<Object> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JSON.toJSONString(parameter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public void setNonNullParameter(PreparedStatement ps, int i, List<Object> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, "[]");
    }

    public List<Object> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return new ArrayList<Object>();
    }

    public List<Object> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return new ArrayList<Object>();
    }

    public List<Object> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return new ArrayList<Object>();
    }
}

