/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.dynamic;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.transaction.Transaction;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.mybatis.spring.transaction.SpringManagedTransaction;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DynamicSpringManagedTransaction
implements Transaction {
    private static final Log LOGGER = LogFactory.getLog(SpringManagedTransaction.class);
    private Map<String, TransactionProxy> connectionMap = new HashMap<String, TransactionProxy>();

    protected TransactionProxy getProxy() {
        return this.connectionMap.get(DataSourceHolder.switcher().currentDataSourceId());
    }

    protected void addProxy(TransactionProxy proxy) {
        this.connectionMap.put(DataSourceHolder.switcher().currentDataSourceId(), proxy);
    }

    protected Collection<TransactionProxy> getAllProxy() {
        return this.connectionMap.values();
    }

    public Connection getConnection() throws SQLException {
        TransactionProxy proxy = this.getProxy();
        if (proxy != null) {
            return proxy.getConnection();
        }
        DataSource dataSource = DataSourceHolder.currentDataSource().getNative();
        String dsId = DataSourceHolder.switcher().currentDataSourceId();
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        proxy = new TransactionProxy(dsId, connection, dataSource);
        this.addProxy(proxy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DataSource (" + (dsId == null ? "default" : dsId) + ") JDBC Connection [" + connection + "] will" + (proxy.isConnectionTransactional ? " " : " not ") + "be managed by Spring");
        }
        return connection;
    }

    public void commit() throws SQLException {
        for (TransactionProxy proxy : this.getAllProxy()) {
            proxy.commit();
        }
    }

    public void rollback() throws SQLException {
        for (TransactionProxy proxy : this.getAllProxy()) {
            proxy.rollback();
        }
    }

    public void close() throws SQLException {
        SQLException tmp = null;
        for (TransactionProxy proxy : this.getAllProxy()) {
            try {
                proxy.close();
            }
            catch (SQLException e) {
                tmp = e;
            }
        }
        this.connectionMap.clear();
        if (null != tmp) {
            throw tmp;
        }
    }

    public Integer getTimeout() throws SQLException {
        return this.getProxy().getTimeout();
    }

    class TransactionProxy
    implements Transaction {
        Connection connection;
        DataSource dataSource;
        boolean isConnectionTransactional;
        boolean autoCommit;
        String dataSourceId;

        public TransactionProxy(String dataSourceId, Connection connection, DataSource dataSource) {
            this.connection = connection;
            this.dataSource = dataSource;
            this.dataSourceId = dataSourceId;
            this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource);
            try {
                this.autoCommit = connection.getAutoCommit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public Connection getConnection() throws SQLException {
            return this.connection;
        }

        public void commit() throws SQLException {
            if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Committing DataSource (" + (this.dataSourceId == null ? "default" : this.dataSourceId) + ") JDBC Connection [" + this.connection + "]");
                }
                this.connection.commit();
            }
        }

        public void rollback() throws SQLException {
            if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Rolling back DataSource (" + this.dataSourceId + ") JDBC Connection [" + this.connection + "]");
                }
                this.connection.rollback();
            }
        }

        public void close() throws SQLException {
            DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)this.dataSource);
        }

        public Integer getTimeout() throws SQLException {
            ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
            if (holder != null && holder.hasTimeout()) {
                return holder.getTimeToLiveInSeconds();
            }
            return null;
        }
    }
}

