/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.builder.jpa;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.persistence.Column;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.converter.BooleanValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.DateTimeConverter;
import org.hswebframework.ezorm.rdb.meta.converter.NumberValueConverter;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.dao.mybatis.builder.TypeUtils;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class JpaAnnotationParser {
    private static final Logger log = LoggerFactory.getLogger(JpaAnnotationParser.class);
    private static final Map<Class, JDBCType> jdbcTypeMapping = new HashMap<Class, JDBCType>();
    private static final List<BiFunction<Class, PropertyDescriptor, JDBCType>> jdbcTypeConvert = new ArrayList<BiFunction<Class, PropertyDescriptor, JDBCType>>();

    public static RDBTableMetaData parseMetaDataFromEntity(Class entityClass) {
        PropertyDescriptor[] descriptors;
        Table table = (Table)AnnotationUtils.findAnnotation((Class)entityClass, Table.class);
        if (table == null) {
            return null;
        }
        RDBTableMetaData tableMetaData = new RDBTableMetaData();
        tableMetaData.setName(table.name());
        for (PropertyDescriptor descriptor : descriptors = BeanUtilsBean.getInstance().getPropertyUtils().getPropertyDescriptors(entityClass)) {
            Class<?> propertyType;
            JDBCType type;
            Column columnAnn = JpaAnnotationParser.getAnnotation(entityClass, descriptor, Column.class);
            if (columnAnn == null) continue;
            RDBColumnMetaData column = new RDBColumnMetaData();
            column.setName(columnAnn.name());
            column.setAlias(descriptor.getName());
            column.setLength(columnAnn.length());
            column.setPrecision(columnAnn.precision());
            column.setJavaType(descriptor.getPropertyType());
            if (!columnAnn.updatable()) {
                column.setProperty("read-only", (Object)true);
            }
            if (!columnAnn.nullable()) {
                column.setNotNull(true);
            }
            if (StringUtils.hasText((String)columnAnn.columnDefinition())) {
                column.setColumnDefinition(columnAnn.columnDefinition());
            }
            if ((type = jdbcTypeMapping.get(propertyType = descriptor.getPropertyType())) == null) {
                type = jdbcTypeConvert.stream().map(func -> (JDBCType)func.apply(entityClass, descriptor)).filter(Objects::nonNull).findFirst().orElse(JDBCType.OTHER);
            }
            column.setJdbcType(type);
            DateTimeConverter dateConvert = new DateTimeConverter("yyyy-MM-dd HH:mm:ss", column.getJavaType()){

                public Object getData(Object value) {
                    if (value instanceof Number) {
                        return new java.util.Date(((Number)value).longValue());
                    }
                    return super.getData(value);
                }
            };
            if (column.getJdbcType() == JDBCType.DATE || column.getJdbcType() == JDBCType.TIMESTAMP) {
                column.setValueConverter((ValueConverter)dateConvert);
            } else if (column.getJavaType() == Boolean.TYPE || column.getJavaType() == Boolean.class) {
                column.setValueConverter((ValueConverter)new BooleanValueConverter(column.getJdbcType()));
            } else if (TypeUtils.isNumberType(column)) {
                column.setValueConverter((ValueConverter)new NumberValueConverter(column.getJavaType()));
            }
            tableMetaData.addColumn(column);
        }
        return tableMetaData;
    }

    private static <T extends Annotation> T getAnnotation(Class entityClass, PropertyDescriptor descriptor, Class<T> type) {
        Annotation ann;
        block4: {
            ann = null;
            try {
                Field field = entityClass.getDeclaredField(descriptor.getName());
                ann = AnnotationUtils.findAnnotation((AnnotatedElement)field, type);
            }
            catch (NoSuchFieldException ignore) {
                if (entityClass.getSuperclass() == Object.class) break block4;
                return JpaAnnotationParser.getAnnotation(entityClass.getSuperclass(), descriptor, type);
            }
        }
        Method read = descriptor.getReadMethod();
        Method write = descriptor.getWriteMethod();
        if (null == ann && read != null) {
            ann = AnnotationUtils.findAnnotation((Method)read, type);
        }
        if (null == ann && write != null) {
            ann = AnnotationUtils.findAnnotation((Method)write, type);
        }
        return (T)ann;
    }

    static {
        jdbcTypeMapping.put(String.class, JDBCType.VARCHAR);
        jdbcTypeMapping.put(Byte.class, JDBCType.TINYINT);
        jdbcTypeMapping.put(Byte.TYPE, JDBCType.TINYINT);
        jdbcTypeMapping.put(Short.class, JDBCType.INTEGER);
        jdbcTypeMapping.put(Short.TYPE, JDBCType.INTEGER);
        jdbcTypeMapping.put(Integer.class, JDBCType.INTEGER);
        jdbcTypeMapping.put(Integer.TYPE, JDBCType.INTEGER);
        jdbcTypeMapping.put(Character.class, JDBCType.CHAR);
        jdbcTypeMapping.put(Character.TYPE, JDBCType.CHAR);
        jdbcTypeMapping.put(Long.class, JDBCType.BIGINT);
        jdbcTypeMapping.put(Long.TYPE, JDBCType.BIGINT);
        jdbcTypeMapping.put(Double.class, JDBCType.DECIMAL);
        jdbcTypeMapping.put(Double.TYPE, JDBCType.DECIMAL);
        jdbcTypeMapping.put(Float.class, JDBCType.DECIMAL);
        jdbcTypeMapping.put(Float.TYPE, JDBCType.DECIMAL);
        jdbcTypeMapping.put(Boolean.class, JDBCType.BIT);
        jdbcTypeMapping.put(Boolean.TYPE, JDBCType.BIT);
        jdbcTypeMapping.put(byte[].class, JDBCType.BLOB);
        jdbcTypeMapping.put(BigDecimal.class, JDBCType.DECIMAL);
        jdbcTypeMapping.put(BigInteger.class, JDBCType.INTEGER);
        jdbcTypeMapping.put(java.util.Date.class, JDBCType.TIMESTAMP);
        jdbcTypeMapping.put(Date.class, JDBCType.TIMESTAMP);
        jdbcTypeMapping.put(Timestamp.class, JDBCType.TIMESTAMP);
        jdbcTypeMapping.put(Object.class, JDBCType.VARCHAR);
        jdbcTypeConvert.add((type, property) -> {
            Enumerated enumerated = JpaAnnotationParser.getAnnotation(type, property, Enumerated.class);
            return enumerated != null ? JDBCType.VARCHAR : null;
        });
        jdbcTypeConvert.add((type, property) -> {
            Lob enumerated = JpaAnnotationParser.getAnnotation(type, property, Lob.class);
            return enumerated != null ? JDBCType.CLOB : null;
        });
        jdbcTypeConvert.add((type, property) -> {
            boolean isArray = type.isArray();
            if (isArray) {
                type = type.getComponentType();
            }
            if (type.isEnum() && EnumDict.class.isAssignableFrom((Class<?>)type)) {
                Class genType = ClassUtils.getGenericType(type);
                if (isArray) {
                    return JDBCType.BIGINT;
                }
                return jdbcTypeMapping.getOrDefault(genType, JDBCType.VARCHAR);
            }
            return null;
        });
    }
}

