/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.builder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;

public class SqlParamParser {
    public static QueryParamEntity parseQueryParam(Object param) {
        return new QueryParamParser().parse(param).get();
    }

    private static class QueryParamParser {
        private Query<?, QueryParamEntity> query = Query.empty((QueryParam)new QueryParamEntity());
        private BiConsumer<String, Object> consumer = (k, v) -> {
            if (k.endsWith("$or")) {
                k = k.substring(0, k.length() - 3);
                this.query.or(k, v);
            } else {
                this.query.and(k, v);
            }
        };

        private QueryParamParser() {
        }

        private QueryParamParser parse(Object obj) {
            if (obj instanceof Map) {
                ((Map)obj).forEach((k, v) -> {
                    String key = String.valueOf(k);
                    if ("pageIndex".equals(key)) {
                        ((QueryParamEntity)this.query.getParam()).setPageIndex(StringUtils.toInt((Object)v));
                    }
                    if ("pageSize".equals(key)) {
                        ((QueryParamEntity)this.query.getParam()).setPageSize(StringUtils.toInt((Object)v));
                    }
                    if (v != null) {
                        if (v instanceof Entity || v instanceof Map) {
                            List terms = new QueryParamParser().parse(v).get().getTerms();
                            Term term = new Term();
                            term.setType(key.equalsIgnoreCase("or") ? Term.Type.or : Term.Type.and);
                            term.setTerms(terms);
                            ((QueryParamEntity)this.query.getParam()).getTerms().add(term);
                        } else {
                            this.consumer.accept(String.valueOf(key), v);
                        }
                    }
                });
            } else {
                this.parse(FastBeanCopier.copy((Object)obj, new LinkedHashMap(), (String[])new String[0]));
            }
            return this;
        }

        private QueryParamEntity get() {
            return (QueryParamEntity)this.query.getParam();
        }
    }
}

