/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis.builder;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.core.param.InsertParam;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.core.param.UpdateParam;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.converter.BooleanValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.DateTimeConverter;
import org.hswebframework.ezorm.rdb.meta.converter.NumberValueConverter;
import org.hswebframework.ezorm.rdb.render.Sql;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.H2RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.MSSQLRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.MysqlRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.OracleRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.PGRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleWhereSqlBuilder;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.dao.mybatis.MybatisUtils;
import org.hswebframework.web.dao.mybatis.builder.InsertSqlBuilder;
import org.hswebframework.web.dao.mybatis.builder.SqlParamParser;
import org.hswebframework.web.dao.mybatis.builder.TypeUtils;
import org.hswebframework.web.dao.mybatis.builder.UpdateSqlBuilder;
import org.hswebframework.web.dao.mybatis.builder.jpa.JpaAnnotationParser;
import org.hswebframework.web.dao.mybatis.plgins.pager.Pager;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyOrmSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(EasyOrmSqlBuilder.class);
    public volatile boolean useJpa = false;
    public EntityFactory entityFactory;
    private static final EasyOrmSqlBuilder instance = new EasyOrmSqlBuilder();
    protected static final Map<Class, String> simpleName = new HashMap<Class, String>();
    protected PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private final RDBDatabaseMetaData mysql = new MysqlMeta();
    private final RDBDatabaseMetaData oracle = new OracleMeta();
    private final RDBDatabaseMetaData h2 = new H2Meta();
    private final RDBDatabaseMetaData postgresql = new PGMeta();
    private final RDBDatabaseMetaData mssql = new MSSQLMeta();
    private final ConcurrentMap<RDBDatabaseMetaData, Map<String, RDBTableMetaData>> metaCache = new ConcurrentHashMap<RDBDatabaseMetaData, Map<String, RDBTableMetaData>>();

    public static EasyOrmSqlBuilder getInstance() {
        return instance;
    }

    private EasyOrmSqlBuilder() {
    }

    public static String getJavaType(Class type) {
        String javaType = simpleName.get(type);
        if (javaType == null) {
            javaType = type.getName();
        }
        return javaType;
    }

    public RDBDatabaseMetaData getActiveDatabase() {
        DatabaseType type = DataSourceHolder.currentDatabaseType();
        switch (type) {
            case mysql: {
                return this.mysql;
            }
            case oracle: {
                return this.oracle;
            }
            case postgresql: {
                return this.postgresql;
            }
            case h2: {
                return this.h2;
            }
            case jtds_sqlserver: 
            case sqlserver: {
                return this.mssql;
            }
        }
        log.warn("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b:[{}]", (Object)type);
        return this.h2;
    }

    private String getRealTableName(String tableName) {
        String newTable = DataSourceHolder.tableSwitcher().getTable(tableName);
        if (!tableName.equals(newTable)) {
            log.debug("use new table [{}] for [{}]", (Object)newTable, (Object)tableName);
        }
        return newTable;
    }

    protected RDBTableMetaData createMeta(String tableName, String resultMapId) {
        Class type;
        RDBTableMetaData parseResult;
        tableName = this.getRealTableName(tableName);
        RDBDatabaseMetaData active = this.getActiveDatabase();
        String cacheKey = tableName.concat("-").concat(resultMapId);
        Map cache = this.metaCache.computeIfAbsent(active, k -> new ConcurrentHashMap());
        RDBTableMetaData cached = (RDBTableMetaData)cache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        RDBTableMetaData rdbTableMetaData = new RDBTableMetaData();
        ResultMap resultMaps = MybatisUtils.getResultMap(resultMapId);
        rdbTableMetaData.setName(tableName);
        rdbTableMetaData.setDatabaseMetaData(active);
        ArrayList resultMappings = new ArrayList(resultMaps.getResultMappings());
        resultMappings.addAll(resultMaps.getIdResultMappings());
        for (ResultMapping resultMapping : resultMappings) {
            if (resultMapping.getNestedQueryId() != null) continue;
            RDBColumnMetaData column = new RDBColumnMetaData();
            column.setJdbcType(JDBCType.valueOf(resultMapping.getJdbcType().name()));
            column.setName(resultMapping.getColumn());
            if (!StringUtils.isNullOrEmpty((Object)resultMapping.getProperty())) {
                column.setAlias(resultMapping.getProperty());
            }
            column.setJavaType(resultMapping.getJavaType());
            column.setProperty("resultMapping", (Object)resultMapping);
            if (column.getJdbcType() == JDBCType.DATE || column.getJdbcType() == JDBCType.TIMESTAMP) {
                DateTimeConverter dateConvert = new DateTimeConverter("yyyy-MM-dd HH:mm:ss", column.getJavaType()){

                    public Object getData(Object value) {
                        if (value instanceof Number) {
                            return new Date(((Number)value).longValue());
                        }
                        return super.getData(value);
                    }
                };
                column.setValueConverter((ValueConverter)dateConvert);
            } else if (column.getJavaType() == Boolean.TYPE || column.getJavaType() == Boolean.class) {
                column.setValueConverter((ValueConverter)new BooleanValueConverter(column.getJdbcType()));
            } else if (TypeUtils.isNumberType(column)) {
                column.setValueConverter((ValueConverter)new NumberValueConverter(column.getJavaType()));
            }
            rdbTableMetaData.addColumn(column);
        }
        if (this.useJpa && (parseResult = JpaAnnotationParser.parseMetaDataFromEntity(type = this.entityFactory == null ? resultMaps.getType() : this.entityFactory.getInstanceType(resultMaps.getType()))) != null) {
            for (RDBColumnMetaData columnMetaData : parseResult.getColumns()) {
                if (rdbTableMetaData.findColumn(columnMetaData.getName()) != null) continue;
                columnMetaData = columnMetaData.clone();
                columnMetaData.setProperty("fromJpa", (Object)true);
                rdbTableMetaData.addColumn(columnMetaData);
            }
        }
        cache.put(cacheKey, rdbTableMetaData);
        return rdbTableMetaData;
    }

    public String buildUpdateFields(String resultMapId, String tableName, UpdateParam param) {
        Pager.reset();
        param.excludes(new String[]{"id"});
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        RDBDatabaseMetaData databaseMetaDate = this.getActiveDatabase();
        Dialect dialect = databaseMetaDate.getDialect();
        CommonSqlRender render = (CommonSqlRender)databaseMetaDate.getRenderer(SqlRender.TYPE.SELECT);
        List columns = render.parseOperationField(tableMetaData, (Param)param);
        SqlAppender appender = new SqlAppender();
        columns.forEach(column -> {
            Object value;
            RDBColumnMetaData columnMetaData = column.getRDBColumnMetaData();
            if (columnMetaData == null) {
                return;
            }
            if (columnMetaData.getName().contains(".")) {
                return;
            }
            try {
                value = this.propertyUtils.getProperty(param.getData(), columnMetaData.getAlias());
                if (value == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            if (value instanceof Sql) {
                appender.add(new Object[]{",", this.encodeColumn(dialect, columnMetaData.getName()), "=", ((Sql)value).getSql()});
            } else {
                appender.add(new Object[]{",", this.encodeColumn(dialect, columnMetaData.getName()), "=", "#{data.", columnMetaData.getAlias(), ",javaType=", EasyOrmSqlBuilder.getJavaType(columnMetaData.getJavaType()), ",jdbcType=", columnMetaData.getJdbcType(), "}"});
            }
        });
        if (appender.isEmpty()) {
            throw new UnsupportedOperationException("\u6ca1\u6709\u5217\u88ab\u4fee\u6539");
        }
        appender.removeFirst();
        return appender.toString();
    }

    public String encodeColumn(Dialect dialect, String field) {
        if (field.contains(".")) {
            String[] tmp = field.split("[.]");
            return tmp[0] + "." + dialect.getQuoteStart() + (dialect.columnToUpperCase() ? tmp[1].toUpperCase() : tmp[1]) + dialect.getQuoteEnd();
        }
        return dialect.getQuoteStart() + (dialect.columnToUpperCase() ? field.toUpperCase() : field) + dialect.getQuoteEnd();
    }

    public String buildInsertSql(String resultMapId, String tableName, Object param) {
        Pager.reset();
        InsertParam insertParam = param instanceof InsertParam ? (InsertParam)param : new InsertParam(param);
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        SqlRender render = tableMetaData.getDatabaseMetaData().getRenderer(SqlRender.TYPE.INSERT);
        return render.render(tableMetaData, (Object)insertParam).getSql();
    }

    public String buildUpdateSql(String resultMapId, String tableName, UpdateParam param) {
        Pager.reset();
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        SqlRender render = tableMetaData.getDatabaseMetaData().getRenderer(SqlRender.TYPE.UPDATE);
        return render.render(tableMetaData, (Object)param).getSql();
    }

    public String buildSelectFields(String resultMapId, String tableName, Object arg) {
        QueryParam param = null;
        if (arg instanceof QueryParam) {
            param = (QueryParam)arg;
        }
        if (param == null) {
            return "*";
        }
        if (param.isPaging() && Pager.get() == null) {
            Pager.doPaging(param.getPageIndex(), param.getPageSize());
        } else {
            Pager.reset();
        }
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        RDBDatabaseMetaData databaseMetaDate = this.getActiveDatabase();
        Dialect dialect = databaseMetaDate.getDialect();
        CommonSqlRender render = (CommonSqlRender)databaseMetaDate.getRenderer(SqlRender.TYPE.SELECT);
        List columns = render.parseOperationField(tableMetaData, (Param)param);
        SqlAppender appender = new SqlAppender();
        columns.forEach(column -> {
            RDBColumnMetaData columnMetaData = column.getRDBColumnMetaData();
            if (columnMetaData == null) {
                return;
            }
            String cname = columnMetaData.getName();
            if (!cname.contains(".")) {
                cname = tableMetaData.getName().concat(".").concat(cname);
            }
            boolean isJpa = columnMetaData.getProperty("fromJpa", (Object)false).isTrue();
            appender.add(new Object[]{",", this.encodeColumn(dialect, cname), " AS ", dialect.getQuoteStart(), isJpa ? columnMetaData.getAlias() : columnMetaData.getName(), dialect.getQuoteEnd()});
        });
        param.getIncludes().remove("*");
        if (appender.isEmpty()) {
            return "*";
        }
        appender.removeFirst();
        return appender.toString();
    }

    public String buildOrder(String resultMapId, String tableName, Object arg) {
        QueryParam param = null;
        if (arg instanceof QueryParam) {
            param = (QueryParam)arg;
        }
        if (param == null) {
            return "";
        }
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        SqlAppender appender = new SqlAppender(" order by ");
        param.getSorts().forEach(sort -> {
            RDBColumnMetaData column = tableMetaData.getColumn(sort.getName());
            if (column == null) {
                column = tableMetaData.findColumn(sort.getName());
            }
            if (column == null) {
                return;
            }
            String cname = column.getName();
            if (!cname.contains(".")) {
                cname = tableMetaData.getName().concat(".").concat(cname);
            }
            appender.add(new Object[]{this.encodeColumn(tableMetaData.getDatabaseMetaData().getDialect(), cname), " ", sort.getOrder(), ","});
        });
        if (appender.isEmpty()) {
            return "";
        }
        appender.removeLast();
        return appender.toString();
    }

    public String buildWhereForUpdate(String resultMapId, String tableName, List<Term> terms) {
        String where = this.buildWhere(resultMapId, tableName, terms);
        if (where.trim().isEmpty()) {
            throw new BusinessException("\u7981\u6b62\u6267\u884c\u65e0\u6761\u4ef6\u7684\u66f4\u65b0\u64cd\u4f5c");
        }
        return where;
    }

    public String buildWhereForUpdate(String resultMapId, String tableName, Object param) {
        String where = this.buildWhere(resultMapId, tableName, param);
        if (where.trim().isEmpty()) {
            throw new BusinessException("\u7981\u6b62\u6267\u884c\u65e0\u6761\u4ef6\u7684\u66f4\u65b0\u64cd\u4f5c");
        }
        return where;
    }

    public String buildWhere(String resultMapId, String tableName, Object param) {
        List<Object> terms = param instanceof Param ? ((Param)param).getTerms() : (param instanceof Entity ? SqlParamParser.parseQueryParam(param).getTerms() : new ArrayList<Term>());
        return this.buildWhere(resultMapId, tableName, terms);
    }

    public String buildWhere(String resultMapId, String tableName, List<Term> terms) {
        RDBTableMetaData tableMetaData = this.createMeta(tableName, resultMapId);
        final RDBDatabaseMetaData databaseMetaDate = this.getActiveDatabase();
        SimpleWhereSqlBuilder builder = new SimpleWhereSqlBuilder(){

            public Dialect getDialect() {
                return databaseMetaDate.getDialect();
            }
        };
        SqlAppender appender = new SqlAppender();
        builder.buildWhere(tableMetaData, "", terms, appender, new HashSet());
        return appender.toString();
    }

    static {
        simpleName.put(Integer.class, "int");
        simpleName.put(Byte.class, "byte");
        simpleName.put(Double.class, "double");
        simpleName.put(Float.class, "float");
        simpleName.put(Boolean.class, "boolean");
        simpleName.put(Long.class, "long");
        simpleName.put(Short.class, "short");
        simpleName.put(Character.class, "char");
        simpleName.put(String.class, "string");
        simpleName.put(Integer.TYPE, "int");
        simpleName.put(Double.TYPE, "double");
        simpleName.put(Float.TYPE, "float");
        simpleName.put(Boolean.TYPE, "boolean");
        simpleName.put(Long.TYPE, "long");
        simpleName.put(Short.TYPE, "short");
        simpleName.put(Character.TYPE, "char");
        simpleName.put(Byte.TYPE, "byte");
    }

    class MSSQLMeta
    extends MSSQLRDBDatabaseMetaData {
        MSSQLMeta() {
            this.renderMap.put(SqlRender.TYPE.INSERT, new InsertSqlBuilder());
            this.renderMap.put(SqlRender.TYPE.UPDATE, new UpdateSqlBuilder(Dialect.MSSQL));
        }
    }

    class PGMeta
    extends PGRDBDatabaseMetaData {
        PGMeta() {
            this.renderMap.put(SqlRender.TYPE.INSERT, new InsertSqlBuilder());
            this.renderMap.put(SqlRender.TYPE.UPDATE, new UpdateSqlBuilder(Dialect.POSTGRES));
        }
    }

    class H2Meta
    extends H2RDBDatabaseMetaData {
        H2Meta() {
            this.renderMap.put(SqlRender.TYPE.INSERT, new InsertSqlBuilder());
            this.renderMap.put(SqlRender.TYPE.UPDATE, new UpdateSqlBuilder(Dialect.H2));
        }
    }

    class OracleMeta
    extends OracleRDBDatabaseMetaData {
        OracleMeta() {
            this.renderMap.put(SqlRender.TYPE.INSERT, new InsertSqlBuilder());
            this.renderMap.put(SqlRender.TYPE.UPDATE, new UpdateSqlBuilder(Dialect.ORACLE));
        }
    }

    class MysqlMeta
    extends MysqlRDBDatabaseMetaData {
        MysqlMeta() {
            this.renderMap.put(SqlRender.TYPE.INSERT, new InsertSqlBuilder());
            this.renderMap.put(SqlRender.TYPE.UPDATE, new UpdateSqlBuilder(Dialect.MYSQL));
        }
    }
}

