/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.web.dao.mybatis.MybatisMapperCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MybatisProperties
extends org.mybatis.spring.boot.autoconfigure.MybatisProperties {
    private static final String defaultMapperLocation = "classpath*:org/hswebframework/web/dao/mybatis/mappers/**/*.xml";
    private boolean dynamicDatasource = false;
    private String[] mapperLocationExcludes = null;
    private boolean useJpa = true;
    private List<MybatisMapperCustomizer> mybatisMappers;

    @Autowired(required=false)
    public void setMybatisMappers(List<MybatisMapperCustomizer> mybatisMappers) {
        this.mybatisMappers = mybatisMappers;
    }

    public String[] getMapperLocationExcludes() {
        return this.mapperLocationExcludes;
    }

    public void setMapperLocationExcludes(String[] mapperLocationExcludes) {
        this.mapperLocationExcludes = mapperLocationExcludes;
    }

    public boolean isDynamicDatasource() {
        return this.dynamicDatasource;
    }

    public void setDynamicDatasource(boolean dynamicDatasource) {
        this.dynamicDatasource = dynamicDatasource;
    }

    public void setUseJpa(boolean useJpa) {
        this.useJpa = useJpa;
    }

    public boolean isUseJpa() {
        return this.useJpa;
    }

    public Resource[] resolveMapperLocations() {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        Set<Object> locations = this.getMapperLocations() == null ? new HashSet<String>() : Arrays.stream(this.getMapperLocations()).collect(Collectors.toSet());
        locations.add(defaultMapperLocation);
        if (this.mybatisMappers != null) {
            this.mybatisMappers.stream().map(MybatisMapperCustomizer::getIncludes).flatMap(Arrays::stream).forEach(locations::add);
        }
        for (String string : locations) {
            try {
                Resource[] mappers;
                for (Resource mapper : mappers = new PathMatchingResourcePatternResolver().getResources(string)) {
                    resources.put(mapper.getURL().toString(), mapper);
                }
            }
            catch (IOException iOException) {
            }
        }
        HashSet<String> excludes = new HashSet<String>();
        if (this.mybatisMappers != null) {
            this.mybatisMappers.stream().map(MybatisMapperCustomizer::getExcludes).flatMap(Arrays::stream).forEach(excludes::add);
        }
        if (this.mapperLocationExcludes != null && this.mapperLocationExcludes.length > 0) {
            for (String exclude : this.mapperLocationExcludes) {
                excludes.add(exclude);
            }
        }
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (String mapperLocationExclude : excludes) {
            try {
                Resource[] excludesMappers;
                for (Resource excludesMapper : excludesMappers = pathMatchingResourcePatternResolver.getResources(mapperLocationExclude)) {
                    resources.remove(excludesMapper.getURL().toString());
                }
            }
            catch (IOException iOException) {
            }
        }
        Resource[] mapperLocations = new Resource[resources.size()];
        mapperLocations = resources.values().toArray(mapperLocations);
        return mapperLocations;
    }
}

