/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis;

import java.util.Arrays;
import java.util.List;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.web.dao.Dao;
import org.hswebframework.web.dao.mybatis.MyBatisAutoConfiguration;
import org.hswebframework.web.dao.mybatis.MybatisProperties;
import org.hswebframework.web.dao.mybatis.mapper.SqlTermCustomizer;
import org.hswebframework.web.dao.mybatis.mapper.dict.DictInTermTypeMapper;
import org.hswebframework.web.dao.mybatis.mapper.dict.DictTermTypeMapper;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.hswebframework.web.dao.mybatis"})
@MapperScan(value={"org.hswebframework.web.dao"}, markerInterface=Dao.class, sqlSessionFactoryRef="sqlSessionFactory")
@AutoConfigureAfter(value={MyBatisAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisDaoAutoConfiguration {
    @Bean
    public DictTermTypeMapper dictTermTypeMapper() {
        return new DictTermTypeMapper(false);
    }

    @Bean
    public DictTermTypeMapper dictNotTermTypeMapper() {
        return new DictTermTypeMapper(true);
    }

    @Bean
    public DictInTermTypeMapper dictInTermTypeMapper() {
        return new DictInTermTypeMapper(false);
    }

    @Bean
    public DictInTermTypeMapper dictNotInTermTypeMapper() {
        return new DictInTermTypeMapper(true);
    }

    @Bean
    public BeanPostProcessor sqlTermCustomizerRegister() {
        final List<Dialect> dialects = Arrays.asList(Dialect.H2, Dialect.MYSQL, Dialect.ORACLE, Dialect.POSTGRES, Dialect.MSSQL);
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof SqlTermCustomizer) {
                    SqlTermCustomizer customizer = (SqlTermCustomizer)bean;
                    if (customizer.forDialect() != null) {
                        for (Dialect dialect2 : customizer.forDialect()) {
                            dialect2.setTermTypeMapper(customizer.getTermType(), (Dialect.TermTypeMapper)customizer);
                        }
                    } else {
                        dialects.forEach(dialect -> dialect.setTermTypeMapper(customizer.getTermType(), (Dialect.TermTypeMapper)customizer));
                    }
                }
                return bean;
            }
        };
    }
}

