/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dao.mybatis;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dict.defaults.DefaultDictDefineRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class EnumDictHandlerRegister {
    private static final Logger log = LoggerFactory.getLogger(EnumDictHandlerRegister.class);
    static TypeHandlerRegistry typeHandlerRegistry;
    private static MetadataReaderFactory metadataReaderFactory;
    private static ResourcePatternResolver resourcePatternResolver;

    public static void register(String packages) {
        EnumDictHandlerRegister.register(StringUtils.tokenizeToStringArray((String)packages, (String)",; \t\n"));
    }

    public static void register(String[] packages) {
        if (typeHandlerRegistry == null) {
            log.error("\u8bf7\u5728spring\u5bb9\u5668\u521d\u59cb\u5316\u540e\u518d\u8c03\u7528\u6b64\u65b9\u6cd5!");
            return;
        }
        for (String basePackage : packages) {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)basePackage) + "/**/*.class";
            try {
                Resource[] resources;
                for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                    try {
                        MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
                        Class<?> enumType = Class.forName(reader.getClassMetadata().getClassName());
                        if (!enumType.isEnum() || !EnumDict.class.isAssignableFrom(enumType)) continue;
                        log.debug("register enum dict:{}", enumType);
                        DefaultDictDefineRepository.registerDefine((DictDefine)DefaultDictDefineRepository.parseEnumDict(enumType));
                        typeHandlerRegistry.register(enumType, new EnumDictHandler(enumType));
                        typeHandlerRegistry.register(Array.newInstance(enumType, 0).getClass(), new EnumDictArrayHandler(enumType));
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                log.warn("register enum dict error", (Throwable)e);
            }
        }
    }

    static {
        metadataReaderFactory = new CachingMetadataReaderFactory();
        resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    @MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.BIT, JdbcType.BOOLEAN, JdbcType.NUMERIC, JdbcType.TINYINT, JdbcType.INTEGER, JdbcType.BIGINT, JdbcType.DECIMAL, JdbcType.CHAR})
    static class EnumDictHandler<T extends Enum>
    implements TypeHandler<T> {
        private Class<T> type;

        public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
            if (parameter == null) {
                ps.setNull(i, jdbcType.TYPE_CODE);
            } else {
                ps.setObject(i, ((EnumDict)parameter).getValue());
            }
        }

        public T getResult(ResultSet rs, String columnName) throws SQLException {
            Object val = rs.getObject(columnName);
            return (T)((Enum)EnumDict.findByValue(this.getType(), (Object)val).orElse(null));
        }

        public T getResult(ResultSet rs, int columnIndex) throws SQLException {
            Object val = rs.getObject(columnIndex);
            return (T)((Enum)EnumDict.findByValue(this.getType(), (Object)val).orElse(null));
        }

        public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
            Object val = cs.getObject(columnIndex);
            return (T)((Enum)EnumDict.findByValue(this.getType(), (Object)val).orElse(null));
        }

        public Class<T> getType() {
            return this.type;
        }

        public void setType(Class<T> type) {
            this.type = type;
        }

        @ConstructorProperties(value={"type"})
        public EnumDictHandler(Class<T> type) {
            this.type = type;
        }
    }

    @MappedJdbcTypes(value={JdbcType.NUMERIC, JdbcType.TINYINT, JdbcType.INTEGER, JdbcType.BIGINT})
    static class EnumDictArrayHandler<T extends Enum>
    implements TypeHandler<Object[]> {
        private Class<T> type;

        public void setParameter(PreparedStatement ps, int i, Object[] parameter, JdbcType jdbcType) throws SQLException {
            Enum[] ts = (Enum[])parameter;
            ps.setLong(i, EnumDict.toMask((EnumDict[])((EnumDict[])ts)));
        }

        public Object[] getResult(ResultSet rs, String columnName) throws SQLException {
            return this.toArray(rs.getLong(columnName));
        }

        public Object[] getResult(ResultSet rs, int columnIndex) throws SQLException {
            return this.toArray(rs.getLong(columnIndex));
        }

        public Object[] getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return this.toArray(cs.getLong(columnIndex));
        }

        private Object[] toArray(Long value) {
            if (null == value) {
                return null;
            }
            List ts = EnumDict.getByMask(this.getType(), (long)value);
            return ts.toArray((Object[])Array.newInstance(this.type, ts.size()));
        }

        public Class<T> getType() {
            return this.type;
        }

        public void setType(Class<T> type) {
            this.type = type;
        }

        @ConstructorProperties(value={"type"})
        public EnumDictArrayHandler(Class<T> type) {
            this.type = type;
        }
    }
}

