/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;

public class AccessLoggerInfo {
    private String id;
    private String action;
    private String describe;
    private Method method;
    private Class target;
    private Map<String, Object> parameters;
    private String ip;
    private String url;
    private Map<String, String> httpHeaders;
    private String httpMethod;
    private Object response;
    private long requestTime;
    private long responseTime;
    private Throwable exception;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Class getTarget() {
        return this.target;
    }

    public void setTarget(Class target) {
        this.target = target;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Map<String, Object> toSimpleMap(Function<Object, Serializable> noSerialExchange) {
        return this.toSimpleMap(noSerialExchange, new LinkedHashMap<String, Object>());
    }

    public Map<String, Object> toSimpleMap(Function<Object, Serializable> objectFilter, Map<String, Object> map) {
        map.put("action", this.action);
        map.put("describe", this.describe);
        if (this.method != null) {
            StringJoiner methodAppender = new StringJoiner(",", this.method.getName().concat("("), ")");
            String[] parameterNames = this.parameters.keySet().toArray(new String[this.parameters.size()]);
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                methodAppender.add(parameterTypes[i].getSimpleName().concat(" ").concat(parameterNames.length > i ? parameterNames[i] : "arg" + i));
            }
            map.put("method", methodAppender.toString());
        }
        map.put("target", this.target != null ? this.target.getName() : "");
        LinkedHashMap<String, Object> newParameter = new LinkedHashMap<String, Object>(this.parameters);
        newParameter.entrySet().forEach(entry -> {
            if (entry.getValue() != null) {
                entry.setValue(objectFilter.apply(entry.getValue()));
            }
        });
        map.put("parameters", newParameter);
        map.put("httpHeaders", this.httpHeaders);
        map.put("httpMethod", this.httpMethod);
        map.put("ip", this.ip);
        map.put("url", this.url);
        map.put("response", objectFilter.apply(this.response));
        map.put("requestTime", this.requestTime);
        map.put("responseTime", this.responseTime);
        map.put("id", this.id);
        map.put("useTime", this.responseTime - this.requestTime);
        if (this.exception != null) {
            StringWriter writer = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(writer));
            map.put("exception", writer.toString());
        }
        return map;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

