/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.DefaultArtifact;

public class SpawnedVMSupport {
    public static Process spawnVM(List<DefaultArtifact> arts, String logName, String className, Properties properties, boolean logOutput, String success, String failure, String workDir, String configDir, boolean debug, String ... args) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("java").append(' ');
        StringBuffer props = new StringBuffer();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                props.append("-D").append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
            }
        }
        String vmarg = props.toString();
        String osName = System.getProperty("os.name");
        osName = osName != null ? osName.toLowerCase() : "";
        boolean isWindows = osName.contains("win");
        if (isWindows) {
            vmarg = vmarg.replaceAll("/", "\\\\");
        }
        sb.append(vmarg).append(" ");
        String pathSeparater = System.getProperty("path.separator");
        StringBuilder classpath = new StringBuilder();
        for (DefaultArtifact artifact : arts) {
            classpath.append(artifact.getFile().getAbsolutePath()).append(pathSeparater);
        }
        classpath.append(configDir).append(pathSeparater);
        if (isWindows) {
            sb.append("-cp").append(" \"").append(classpath.toString()).append("\" ");
        } else {
            sb.append("-cp").append(" ").append(classpath.toString()).append(" ");
        }
        String libPath = "-Djava.library.path=" + System.getProperty("java.library.path", "./native/bin");
        if (isWindows) {
            libPath = libPath.replaceAll("/", "\\\\");
            libPath = "\"" + libPath + "\"";
        }
        sb.append("-Djava.library.path=").append(libPath).append(" ");
        if (debug) {
            sb.append("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005 ");
        }
        sb.append(className).append(' ');
        for (String arg : args) {
            sb.append(arg).append(' ');
        }
        String commandLine = sb.toString();
        Process process = Runtime.getRuntime().exec(commandLine, null, new File(workDir));
        CountDownLatch latch = new CountDownLatch(1);
        ProcessLogger outputLogger = new ProcessLogger(logOutput, process.getInputStream(), logName, false, success, failure, latch);
        outputLogger.start();
        ProcessLogger errorLogger = new ProcessLogger(true, process.getErrorStream(), logName, true, success, failure, latch);
        errorLogger.start();
        if (!latch.await(60L, TimeUnit.SECONDS)) {
            process.destroy();
            throw new RuntimeException("Timed out waiting for server to start");
        }
        if (outputLogger.failed || errorLogger.failed) {
            try {
                process.destroy();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw new RuntimeException("server failed to start");
        }
        return process;
    }

    static class ProcessLogger
    extends Thread {
        private final InputStream is;
        private final String logName;
        private final boolean print;
        private final boolean sendToErr;
        private final String success;
        private final String failure;
        private final CountDownLatch latch;
        boolean failed = false;

        ProcessLogger(boolean print, InputStream is, String logName, boolean sendToErr, String success, String failure, CountDownLatch latch) throws ClassNotFoundException {
            this.is = is;
            this.print = print;
            this.logName = logName;
            this.sendToErr = sendToErr;
            this.success = success;
            this.failure = failure;
            this.latch = latch;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith(this.success)) {
                        this.failed = false;
                        this.latch.countDown();
                    } else if (line.startsWith(this.failure)) {
                        this.failed = true;
                        this.latch.countDown();
                    }
                    if (!this.print) continue;
                    if (this.sendToErr) {
                        System.err.println(this.logName + " err:" + line);
                        continue;
                    }
                    System.out.println(this.logName + " out:" + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

