/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.maven;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.hornetq.maven.PluginUtil;
import org.hornetq.maven.TestClusterManager;
import org.hornetq.maven.TestClusterManagerMBean;
import org.hornetq.server.HornetQBootstrap;
import org.hornetq.server.SpawnedHornetQBootstrap;
import org.hornetq.server.SpawnedVMSupport;
import org.hornetq.spi.core.security.HornetQSecurityManager;

public class HornetQStartPlugin
extends AbstractMojo {
    private PluginDescriptor descriptor;
    private Boolean waitOnStart;
    private String hornetqConfigurationDir;
    private Boolean useJndi;
    private String nodeId;
    private String jndiHost;
    private int jndiPort;
    private int jndiRmiPort;
    private Boolean fork;
    private Boolean debug;
    private Properties systemProperties;
    private String serverStartString;
    private HornetQSecurityManager securityManager;
    private boolean testClusterManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.testClusterManager) {
            try {
                this.createClusterManagerMBean();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create cluster manager mbean", e);
            }
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            System.getProperties().putAll((Map<?, ?>)this.systemProperties);
        }
        String workingPath = new File(".").getAbsolutePath();
        try {
            this.registerNode(this.nodeId, workingPath, this.hornetqConfigurationDir, this.jndiPort, this.jndiRmiPort);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Failed to create cluster manager mbean", e1);
        }
        if (this.fork.booleanValue()) {
            try {
                PluginDescriptor pd = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                final Process p = SpawnedVMSupport.spawnVM(pd.getArtifacts(), "HornetQServer_" + (this.nodeId != null ? this.nodeId : ""), SpawnedHornetQBootstrap.class.getName(), this.systemProperties, true, this.serverStartString, "FAILED::", ".", this.hornetqConfigurationDir, this.debug, this.useJndi.toString(), this.jndiHost, "" + this.jndiPort, "" + this.jndiRmiPort, this.hornetqConfigurationDir, "" + this.waitOnStart, this.nodeId);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        p.destroy();
                    }
                });
                if (!this.waitOnStart.booleanValue()) return;
                p.waitFor();
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }
        }
        HornetQBootstrap bootstrap = new HornetQBootstrap(this.useJndi, this.jndiHost, this.jndiPort, this.jndiRmiPort, this.hornetqConfigurationDir, this.waitOnStart, this.nodeId, this.securityManager);
        if (this.hornetqConfigurationDir != null) {
            this.extendPluginClasspath(this.hornetqConfigurationDir);
        }
        try {
            bootstrap.execute();
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void registerNode(String nodeId, String workingPath, String hornetqConfigurationDir, int jndiPort, int jndiRmiPort) throws Exception {
        TestClusterManagerMBean control = PluginUtil.getTestClusterManager();
        if (control != null) {
            control.registerNode(nodeId, workingPath, hornetqConfigurationDir, jndiPort, jndiRmiPort);
        }
    }

    private void createClusterManagerMBean() throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = ObjectName.getInstance("hornetq:module=test,type=TestClusterManager");
        mbeanServer.registerMBean(new TestClusterManager(), name);
    }

    public void extendPluginClasspath(String element) throws MojoExecutionException {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        try {
            realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName() + (this.nodeId == null ? "" : this.nodeId), Thread.currentThread().getContextClassLoader());
            File elementFile = new File(element);
            this.getLog().debug((CharSequence)("Adding element to plugin classpath" + elementFile.getPath()));
            realm.addConstituent(elementFile.toURI().toURL());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
        System.out.println(Arrays.toString(realm.getConstituents()));
        Thread.currentThread().setContextClassLoader(realm.getClassLoader());
    }
}

