/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.logging.Logger;

class StompFrame {
    private static final Logger log = Logger.getLogger(StompFrame.class);
    public static final byte[] NO_DATA = new byte[0];
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    private final String command;
    private final Map<String, Object> headers;
    private final byte[] content;
    private HornetQBuffer buffer = null;
    private int size;

    public StompFrame(String command, Map<String, Object> headers, byte[] data) {
        this.command = command;
        this.headers = headers;
        this.content = data;
    }

    public StompFrame(String command, Map<String, Object> headers) {
        this.command = command;
        this.headers = headers;
        this.content = NO_DATA;
    }

    public String getCommand() {
        return this.command;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public int getEncodedSize() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.toHornetQBuffer();
        }
        return this.size;
    }

    public String toString() {
        return "StompFrame[command=" + this.command + ", headers=" + this.headers + ", content-length=" + this.content.length + "]";
    }

    public HornetQBuffer toHornetQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = HornetQBuffers.dynamicBuffer(this.content.length + 512);
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (Map.Entry<String, Object> header : this.headers.entrySet()) {
                head.append(header.getKey());
                head.append(":");
                head.append(header.getValue());
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes("UTF-8"));
            this.buffer.writeBytes(this.content);
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        }
        return this.buffer;
    }
}

