/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.flat;

import groovyx.gprof.ReportPrinter;
import groovyx.gprof.ThreadInfo;
import groovyx.gprof.flat.FlatReportMethodElement;
import groovyx.gprof.flat.FlatReportThreadElement;
import java.io.PrintWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatReportPrinter
implements ReportPrinter<FlatReportThreadElement> {
    private static String SP = "  ";
    private boolean separateThread;

    public void setSeparateThread(boolean separateThread) {
        this.separateThread = separateThread;
    }

    @Override
    public void print(List<FlatReportThreadElement> threadElements, PrintWriter writer) {
        Iterator<FlatReportThreadElement> it = threadElements.iterator();
        while (it.hasNext()) {
            FlatReportThreadElement threadElement = it.next();
            if (threadElement.getMethodElements().isEmpty()) continue;
            if (this.separateThread) {
                this.printThreadHeader(threadElement, writer);
            }
            this.printThread(threadElement, writer);
            if (!this.separateThread || !it.hasNext()) continue;
            this.printThreadSeparator(writer);
        }
        writer.flush();
    }

    protected void printThreadHeader(FlatReportThreadElement threadElement, PrintWriter writer) {
        ThreadInfo thread = threadElement.getThread();
        writer.printf("#%d %s%n%n", thread.getThreadId(), thread.getThreadName());
    }

    protected void printThreadSeparator(PrintWriter writer) {
        writer.println();
    }

    private void printThread(FlatReportThreadElement threadElement, PrintWriter writer) {
        List<Map<COLUMN, String>> rows = this.createRowValueList(threadElement.getMethodElements());
        Map<COLUMN, Integer> columnSizeMap = this.calculateColumnSize(rows);
        this.writeHeader(writer, columnSizeMap);
        this.writeRows(writer, rows, columnSizeMap);
    }

    private void writeRows(PrintWriter writer, List<Map<COLUMN, String>> rows, Map<COLUMN, Integer> columnSizeMap) {
        COLUMN[] columns = COLUMN.values();
        int columnNum = columns.length;
        StringBuilder rowFormatBuff = new StringBuilder();
        for (int i = 0; i < columnNum; ++i) {
            if (i > 0) {
                rowFormatBuff.append(SP);
            }
            int columnSize = columnSizeMap.get((Object)columns[i]);
            rowFormatBuff.append(String.format(columns[i].format, columnSize));
        }
        String rowFormat = rowFormatBuff.append("%n").toString();
        for (Map<COLUMN, String> row : rows) {
            Object[] rowValues = new String[columnNum];
            for (int i = 0; i < columnNum; ++i) {
                rowValues[i] = row.get((Object)columns[i]);
            }
            writer.printf(rowFormat, rowValues);
        }
    }

    private void writeHeader(PrintWriter writer, Map<COLUMN, Integer> columnSizeMap) {
        int i;
        COLUMN[] columns = COLUMN.values();
        int columnNum = columns.length;
        StringBuilder headerFormatBuff = new StringBuilder();
        block3: for (int i2 = 0; i2 < columnNum; ++i2) {
            if (i2 > 0) {
                headerFormatBuff.append(SP);
            }
            COLUMN column = columns[i2];
            columnSizeMap.get((Object)columns[i2]);
            int columnSize = columnSizeMap.get((Object)column);
            switch (column) {
                case CUMULATIVE_TIME: 
                case SELF_TIME: 
                case CALLS: 
                case SELF_TIME_PER_CALL: 
                case TOTAL_TIME_PER_CALL: 
                case SELF_MIN_TIME: 
                case TOTAL_MIN_TIME: 
                case SELF_MAX_TIME: 
                case TOTAL_MAX_TIME: {
                    headerFormatBuff.append(String.format("%%%ds", columnSize));
                    continue block3;
                }
                default: {
                    headerFormatBuff.append(String.format("%%-%ds", columnSize));
                }
            }
        }
        String headerFormat = headerFormatBuff.append("%n").toString();
        Object[] headerValues = new String[columnNum];
        for (i = 0; i < columnNum; ++i) {
            headerValues[i] = columns[i].header1;
        }
        writer.printf(headerFormat, headerValues);
        for (i = 0; i < columnNum; ++i) {
            headerValues[i] = columns[i].header2;
        }
        writer.printf(headerFormat, headerValues);
    }

    private Map<COLUMN, Integer> calculateColumnSize(List<Map<COLUMN, String>> rows) {
        HashMap<COLUMN, Integer> colSizeMap = new HashMap<COLUMN, Integer>();
        for (COLUMN col : COLUMN.values()) {
            colSizeMap.put(col, Math.max(col.header1.length(), col.header2.length()));
        }
        for (Map<COLUMN, String> row : rows) {
            for (COLUMN col : COLUMN.values()) {
                colSizeMap.put(col, Math.max((Integer)colSizeMap.get((Object)col), row.get((Object)col).length()));
            }
        }
        return colSizeMap;
    }

    private List<Map<COLUMN, String>> createRowValueList(List<FlatReportMethodElement> elements) {
        ArrayList<Map<COLUMN, String>> rows = new ArrayList<Map<COLUMN, String>>(elements.size());
        for (FlatReportMethodElement element : elements) {
            HashMap<COLUMN, String> row = new HashMap<COLUMN, String>();
            row.put(COLUMN.TIME_PERCENT, Formatter.percent(element.getTimePercent()));
            row.put(COLUMN.CUMULATIVE_TIME, Formatter.sec(element.getCumulativeTime()));
            row.put(COLUMN.SELF_TIME, Formatter.sec(element.getSelfTime()));
            row.put(COLUMN.CALLS, String.format("%d", element.getCalls()));
            row.put(COLUMN.SELF_TIME_PER_CALL, Formatter.msec(element.getSelfTimePerCall()));
            row.put(COLUMN.TOTAL_TIME_PER_CALL, Formatter.msec(element.getTimePerCall()));
            row.put(COLUMN.SELF_MIN_TIME, Formatter.msec(element.getMinSelfTime()));
            row.put(COLUMN.TOTAL_MIN_TIME, Formatter.msec(element.getMinTime()));
            row.put(COLUMN.SELF_MAX_TIME, Formatter.msec(element.getMaxSelfTime()));
            row.put(COLUMN.TOTAL_MAX_TIME, Formatter.msec(element.getMaxTime()));
            row.put(COLUMN.NAME, Formatter.name(element.getMethod().getClassName(), element.getMethod().getMethodName()));
            rows.add(row);
        }
        return rows;
    }

    private static class Formatter {
        private static Format TIME_PERCENT_FORMAT;
        private static Format TIME_FORMAT;

        private Formatter() {
        }

        public static String sec(float ns) {
            return TIME_FORMAT.format((double)ns * 1.0E-9);
        }

        public static String msec(float ns) {
            return TIME_FORMAT.format((double)ns * 1.0E-6);
        }

        public static String percent(double percent) {
            return TIME_PERCENT_FORMAT.format(percent);
        }

        public static String name(String className, String methodName) {
            return String.format("%s.%s", className, methodName);
        }

        static {
            DecimalFormat df = new DecimalFormat("0.0");
            df.setRoundingMode(RoundingMode.DOWN);
            TIME_PERCENT_FORMAT = df;
            df = new DecimalFormat("0.00");
            df.setRoundingMode(RoundingMode.DOWN);
            TIME_FORMAT = df;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COLUMN {
        TIME_PERCENT(" %  ", "time", "%%%ds"),
        CUMULATIVE_TIME("cumulative", " seconds  ", "%%%ds"),
        SELF_TIME(" self  ", "seconds", "%%%ds"),
        CALLS("     ", "calls", "%%%ds"),
        SELF_TIME_PER_CALL(" self  ", "ms/call", "%%%ds"),
        TOTAL_TIME_PER_CALL(" total ", "ms/call", "%%%ds"),
        SELF_MIN_TIME(" self ", "min ms", "%%%ds"),
        TOTAL_MIN_TIME(" total", "min ms", "%%%ds"),
        SELF_MAX_TIME(" self ", "max ms", "%%%ds"),
        TOTAL_MAX_TIME(" total", "max ms", "%%%ds"),
        NAME("    ", "name", "%%-%ds");

        private String header1;
        private String header2;
        private String format;

        private COLUMN(String header1, String header2, String format) {
            this.header1 = header1;
            this.header2 = header2;
            this.format = format;
        }
    }
}

