/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.callgraph;

import groovyx.gprof.ReportPrinter;
import groovyx.gprof.ThreadInfo;
import groovyx.gprof.Utils;
import groovyx.gprof.callgraph.CallGraphReportMethodElement;
import groovyx.gprof.callgraph.CallGraphReportThreadElement;
import groovyx.gprof.callgraph.CallGraphReportWholeCycleElement;
import java.io.PrintWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphReportPrinter
implements ReportPrinter<CallGraphReportThreadElement> {
    private static Character SEPARATOR_CHAR = Character.valueOf('-');
    private static String COLUMN_SEPARATOR = "  ";
    private static String SPONTANEOUS = "<spontaneous>";
    private boolean separateThread;

    public void setSeparateThread(boolean separateThread) {
        this.separateThread = separateThread;
    }

    @Override
    public void print(List<CallGraphReportThreadElement> threadElements, PrintWriter writer) {
        Iterator<CallGraphReportThreadElement> it = threadElements.iterator();
        while (it.hasNext()) {
            CallGraphReportThreadElement threadElement = it.next();
            if (threadElement.getSubElements().isEmpty()) continue;
            if (this.separateThread) {
                this.printThreadHeader(threadElement, writer);
            }
            this.printThread(threadElement, writer);
            if (!this.separateThread || !it.hasNext()) continue;
            this.printThreadSeparator(writer);
        }
        writer.flush();
    }

    protected void printThreadHeader(CallGraphReportThreadElement threadElement, PrintWriter writer) {
        ThreadInfo thread = threadElement.getThread();
        writer.printf("#%d %s%n%n", thread.getThreadId(), thread.getThreadName());
    }

    protected void printThreadSeparator(PrintWriter writer) {
        writer.println();
    }

    /*
     * WARNING - void declaration
     */
    protected void printThread(CallGraphReportThreadElement te, PrintWriter writer) {
        void var9_13;
        Collection<CallGraphReportMethodElement> elements = te.getSubElements();
        HashMap<Long, CallGraphReportMethodElement> graphTable = new HashMap<Long, CallGraphReportMethodElement>();
        for (CallGraphReportMethodElement entry : elements) {
            graphTable.put(entry.getIndex(), entry);
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        HashMap<Column, String> header = new HashMap<Column, String>();
        Column[] arr$ = Column.values();
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_13 < len$) {
            Column col = arr$[var9_13];
            header.put(col, col.toString());
            ++var9_13;
        }
        lines.add(header);
        for (CallGraphReportMethodElement element : elements) {
            if (!element.getParents().isEmpty()) {
                for (CallGraphReportMethodElement.Parent parent : element.getParents().values()) {
                    if (parent.getIndex() == 0L) {
                        lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, Formatter.time(parent.getSelfTime()), Column.CHILDREN_TIME, Formatter.time(parent.getChildrenTime()), Column.CALLS, Formatter.childCalls(parent.getCalls() - parent.getRecursiveCalls() - parent.getCycleCalls(), element.getCalls() - element.getRecursiveCalls() - element.getCycleCalls()), Column.NAME, Formatter.indent(SPONTANEOUS)}));
                        continue;
                    }
                    if (parent.getIndex() == element.getIndex()) continue;
                    CallGraphReportMethodElement parentRef = (CallGraphReportMethodElement)graphTable.get(parent.getIndex());
                    if (parentRef.getCycleIndex() > 0L && parentRef.getCycleIndex() == element.getCycleIndex()) {
                        lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, "", Column.CHILDREN_TIME, "", Column.CALLS, Formatter.cycleChildCalls(parent.getCalls() - parent.getRecursiveCalls() - parent.getCycleCalls()), Column.NAME, Formatter.indent(Formatter.name(parentRef.getMethod().getClassName(), parentRef.getMethod().getMethodName(), parentRef.getIndex(), parentRef.getCycleIndex()))}));
                        continue;
                    }
                    lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, Formatter.time(parent.getSelfTime()), Column.CHILDREN_TIME, Formatter.time(parent.getChildrenTime()), Column.CALLS, Formatter.childCalls(parent.getCalls() - parent.getRecursiveCalls(), element.getCalls() - element.getRecursiveCalls()), Column.NAME, Formatter.indent(Formatter.name(parentRef.getMethod().getClassName(), parentRef.getMethod().getMethodName(), parentRef.getIndex(), parentRef.getCycleIndex()))}));
                }
            }
            lines.add(this.primaryLine(element));
            for (CallGraphReportMethodElement.Child child : element.getChildren().values()) {
                CallGraphReportMethodElement childRef = (CallGraphReportMethodElement)graphTable.get(child.getIndex());
                CallGraphReportMethodElement.Parent childParent = childRef.getParents().get(element.getIndex());
                if (element instanceof CallGraphReportWholeCycleElement) {
                    lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, Formatter.time(childRef.getSelfTime()), Column.CHILDREN_TIME, Formatter.time(childRef.getChildrenTime()), Column.CALLS, Formatter.primaryCalls(childRef.getCalls(), childRef.getRecursiveCalls()), Column.NAME, Formatter.indent(Formatter.name(childRef.getMethod().getClassName(), childRef.getMethod().getMethodName(), childRef.getIndex(), childRef.getCycleIndex()))}));
                    continue;
                }
                if (childRef.getCycleIndex() > 0L && childRef.getCycleIndex() == element.getCycleIndex()) {
                    lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, "", Column.CHILDREN_TIME, "", Column.CALLS, Formatter.cycleChildCalls(childParent.getCalls() - childParent.getRecursiveCalls() - childParent.getCycleCalls()), Column.NAME, Formatter.indent(Formatter.name(childRef.getMethod().getClassName(), childRef.getMethod().getMethodName(), childRef.getIndex(), childRef.getCycleIndex()))}));
                    continue;
                }
                lines.add(Utils.hashMap(new Object[]{Column.INDEX, "", Column.TOTAL_TIME_PERCENT, "", Column.SELF_TIME, Formatter.time(childParent.getSelfTime()), Column.CHILDREN_TIME, Formatter.time(childParent.getChildrenTime()), Column.CALLS, Formatter.childCalls(childParent.getCalls() - childParent.getRecursiveCalls(), childRef.getCalls() - childRef.getRecursiveCalls()), Column.NAME, Formatter.indent(Formatter.name(childRef.getMethod().getClassName(), childRef.getMethod().getMethodName(), childRef.getIndex(), childRef.getCycleIndex()))}));
            }
            lines.add(SEPARATOR_CHAR);
        }
        HashMap<Column, Integer> columnWidth = new HashMap<Column, Integer>();
        for (Column col : Column.values()) {
            columnWidth.put(col, 0);
        }
        for (Object e : lines) {
            if (!(e instanceof Map)) continue;
            Map cols = (Map)e;
            for (Column col : cols.keySet()) {
                columnWidth.put(col, Math.max((Integer)columnWidth.get((Object)col), ((String)cols.get((Object)col)).length()));
            }
        }
        int rowWidth = 0;
        Iterator iterator = columnWidth.values().iterator();
        while (iterator.hasNext()) {
            int w = (Integer)iterator.next();
            rowWidth += w;
        }
        rowWidth += COLUMN_SEPARATOR.length() * (columnWidth.values().size() - 2);
        for (Object line : lines) {
            if (!(line instanceof Map)) continue;
            Map cols = (Map)line;
            for (Column col : Column.values()) {
                String format;
                if (col == Column.SPAN) continue;
                int w = (Integer)columnWidth.get((Object)col);
                if (line == header) {
                    format = "%-" + w + "s";
                } else {
                    switch (col) {
                        case TOTAL_TIME_PERCENT: 
                        case SELF_TIME: 
                        case CHILDREN_TIME: 
                        case CALLS: {
                            format = "%" + w + "s";
                            break;
                        }
                        default: {
                            format = "%-" + w + "s";
                        }
                    }
                }
                cols.put(col, String.format(format, cols.get((Object)col)));
            }
        }
        List<Column> list = Arrays.asList(Column.INDEX, Column.TOTAL_TIME_PERCENT, Column.SELF_TIME, Column.CHILDREN_TIME, Column.CALLS, Column.NAME);
        String separator = this.methodSeparator(rowWidth);
        for (Object line : lines) {
            if (line instanceof Map) {
                Map cols = (Map)line;
                ArrayList vs = new ArrayList(list.size());
                for (Column col : list) {
                    vs.add(cols.get((Object)col));
                }
                writer.println(Utils.join(vs, "  "));
                continue;
            }
            if (line != SEPARATOR_CHAR) continue;
            writer.println(separator);
        }
    }

    private Object primaryLine(CallGraphReportMethodElement element) {
        String name = element instanceof CallGraphReportWholeCycleElement ? String.format("<cycle %d as a whole> " + Formatter.index(element.getIndex()), element.getCycleIndex()) : Formatter.name(element.getMethod().getClassName(), element.getMethod().getMethodName(), element.getIndex(), element.getCycleIndex());
        return Utils.hashMap(new Object[]{Column.INDEX, Formatter.index(element.getIndex()), Column.TOTAL_TIME_PERCENT, Formatter.percent(element.getTimePercent()), Column.SELF_TIME, Formatter.time(element.getSelfTime()), Column.CHILDREN_TIME, Formatter.time(element.getChildrenTime()), Column.CALLS, Formatter.primaryCalls(element.getCalls(), element.getRecursiveCalls()), Column.NAME, name});
    }

    private String methodSeparator(int rowWidth) {
        StringBuilder separatorBuff = new StringBuilder();
        for (int i = 0; i < rowWidth; ++i) {
            separatorBuff.append(SEPARATOR_CHAR);
        }
        return separatorBuff.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        INDEX("index"),
        TOTAL_TIME_PERCENT("% time"),
        SELF_TIME("self"),
        CHILDREN_TIME("children"),
        CALLS("calls"),
        NAME("name"),
        SPAN("");

        private String name;

        private Column(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Formatter {
        private static Format TIME_PERCENT_FORMAT;
        private static Format TIME_FORMAT;

        private Formatter() {
        }

        public static String index(long index) {
            return String.format("[%d]", index);
        }

        public static String cycleIndex(long number) {
            return String.format("<cycle %d>", number);
        }

        public static String time(long ns) {
            return TIME_FORMAT.format((double)ns * 1.0E-9);
        }

        public static String percent(double percent) {
            return TIME_PERCENT_FORMAT.format(percent);
        }

        public static String indent(String s) {
            return "    " + s;
        }

        public static String name(String className, String methodName, long index, long cycleIndex) {
            String s = String.format("%s.%s", className, methodName);
            if (cycleIndex > 0L) {
                s = s + " " + Formatter.cycleIndex(cycleIndex);
            }
            s = s + " " + Formatter.index(index);
            return s;
        }

        public static String primaryCalls(long totalCalls, long recursiveCalls) {
            if (recursiveCalls > 0L) {
                return String.format("%d+%d", totalCalls - recursiveCalls, recursiveCalls);
            }
            return String.format("%d", totalCalls);
        }

        public static String childCalls(long calls, long totalCalls) {
            return String.format("%d/%d", calls, totalCalls);
        }

        public static String cycleChildCalls(long calls) {
            return String.format("%d", calls);
        }

        static {
            DecimalFormat df = new DecimalFormat("0.0");
            df.setRoundingMode(RoundingMode.DOWN);
            TIME_PERCENT_FORMAT = df;
            df = new DecimalFormat("0.00");
            df.setRoundingMode(RoundingMode.DOWN);
            TIME_FORMAT = df;
        }
    }
}

