/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login.common;

import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ServerLoginCallbackHandler
implements CallbackHandler {
    private static final String GP_CB = "javax.security.auth.message.callback.GroupPrincipalCallback";
    private static final String GPCBH_UTIL = "com.sun.enterprise.security.jmac.callback.ServerLoginCBHUtil";
    private static final String GPCBH_UTIL_METHOD = "processGroupPrincipal";
    private String username = null;
    private String password = null;
    private String moduleID = null;

    public ServerLoginCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public ServerLoginCallbackHandler(String username, String password, String moduleID) {
        this.username = username;
        this.password = password;
        this.moduleID = moduleID;
    }

    public ServerLoginCallbackHandler() {
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nme = (NameCallback)callbacks[i];
                nme.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pswd = (PasswordCallback)callbacks[i];
                pswd.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof CertificateRealm.AppContextCallback) {
                ((CertificateRealm.AppContextCallback)callbacks[i]).setModuleID(this.moduleID);
                continue;
            }
            if (GP_CB.equals(callbacks[i].getClass().getName())) {
                ServerLoginCallbackHandler.processGroupPrincipal(callbacks[i]);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private static void processGroupPrincipal(Callback callback) throws UnsupportedCallbackException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(GPCBH_UTIL);
            Method meth = clazz.getMethod(GPCBH_UTIL_METHOD, Callback.class);
            meth.invoke(null, callback);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedCallbackException(callback);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedCallbackException(callback);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedCallbackException(callback);
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedCallbackException(callback);
        }
        catch (SecurityException ex) {
            throw new UnsupportedCallbackException(callback);
        }
        catch (ClassNotFoundException ex) {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

