/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.annotation.context.ComponentContext;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

public abstract class AbstractAttributeHandler
extends AbstractHandler {
    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, EjbContext[] var2) throws AnnotationProcessorException;

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbInterceptorContext ejbInterceptorContext) throws AnnotationProcessorException {
        if (!this.isDelegatee()) {
            throw new UnsupportedOperationException();
        }
        return this.getDefaultProcessedResult();
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler;
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("@process annotation " + annotation + " in " + ae);
        }
        if ((aeHandler = ainfo.getProcessingContext().getHandler()) instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            AnnotatedElementHandler aeh = ejbBundleContext.createContextForEjb();
            if (aeh != null) {
                aeHandler = aeh;
            } else {
                if (this.isDelegatee()) {
                    aeHandler = ejbBundleContext.createContextForEjbInterceptor();
                }
                if (aeHandler == null) {
                    return this.getInvalidAnnotatedElementHandlerResult(null, ainfo);
                }
            }
        }
        if (!this.supportTypeInheritance() && ElementType.TYPE.equals((Object)ainfo.getElementType()) && aeHandler instanceof ComponentContext) {
            ComponentContext context = (ComponentContext)aeHandler;
            Class clazz = (Class)ainfo.getAnnotatedElement();
            if (!clazz.getName().equals(context.getComponentClassName())) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.typeinhernotsupp", "The annotation symbol inheritance is not supported."));
                }
                return this.getDefaultProcessedResult();
            }
        }
        EjbContext[] ejbContexts = null;
        EjbInterceptorContext ejbInterceptorContext = null;
        if (aeHandler instanceof EjbContext) {
            EjbContext ejbContext = (EjbContext)aeHandler;
            ejbContexts = new EjbContext[]{ejbContext};
        } else if (aeHandler instanceof EjbsContext) {
            ejbContexts = ((EjbsContext)aeHandler).getEjbContexts();
        } else if (this.isDelegatee() && aeHandler instanceof EjbInterceptorContext) {
            ejbInterceptorContext = (EjbInterceptorContext)aeHandler;
        } else {
            return this.getInvalidAnnotatedElementHandlerResult(aeHandler, ainfo);
        }
        HandlerProcessingResult procResult = null;
        procResult = ejbInterceptorContext != null ? this.processAnnotation(ainfo, ejbInterceptorContext) : this.processAnnotation(ainfo, ejbContexts);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("New annotation for " + annotation);
        }
        return procResult;
    }

    protected boolean isDelegatee() {
        return false;
    }

    protected boolean supportTypeInheritance() {
        return false;
    }
}

