/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ResourcePropertyNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdministeredObjectDefinitionNode
extends DeploymentDescriptorNode<AdministeredObjectDefinitionDescriptor> {
    public static final XMLElement tag = new XMLElement("administered-object");
    private AdministeredObjectDefinitionDescriptor descriptor = null;
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "AS-DEPLOYMENT-00022";

    public AdministeredObjectDefinitionNode() {
        this.registerElementHandler(new XMLElement("property"), ResourcePropertyNode.class, "addAdministeredObjectPropertyDescriptor");
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("name", "setName");
        table.put("interface-name", "setInterfaceName");
        table.put("class-name", "setClassName");
        table.put("resource-adapter", "setResourceAdapter");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, AdministeredObjectDefinitionDescriptor desc) {
        Element node = AdministeredObjectDefinitionNode.appendChild(parent, nodeName);
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "description", desc.getDescription());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "name", desc.getName());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "interface-name", desc.getInterfaceName());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "class-name", desc.getClassName());
        String resourceAdapterName = desc.getResourceAdapter();
        int poundIndex = resourceAdapterName.indexOf("#");
        if (poundIndex > 0) {
            resourceAdapterName = resourceAdapterName.substring(poundIndex);
        } else if (poundIndex == 0) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, RESOURCE_ADAPTER_NAME_INVALID, new Object[]{desc.getName(), desc.getResourceAdapter()});
        }
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "resource-adapter", resourceAdapterName);
        ResourcePropertyNode propertyNode = new ResourcePropertyNode();
        propertyNode.writeDescriptor((Node)node, desc);
        return node;
    }

    @Override
    public AdministeredObjectDefinitionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new AdministeredObjectDefinitionDescriptor();
        }
        return this.descriptor;
    }
}

