/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.JavaEEResourceType;

public class ResourceDescriptorRegistry
implements Serializable {
    private static Map<JavaEEResourceType, Set<Class>> invalidResourceTypeScopes = new HashMap<JavaEEResourceType, Set<Class>>();
    private static LocalStringManagerImpl localStrings;
    private Map<JavaEEResourceType, Set<ResourceDescriptor>> resourceDescriptors = new HashMap<JavaEEResourceType, Set<ResourceDescriptor>>();

    public Set<ResourceDescriptor> getAllResourcesDescriptors() {
        HashSet<ResourceDescriptor> allResourceDescriptors = new HashSet<ResourceDescriptor>();
        Collections.unmodifiableSet(allResourceDescriptors);
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.DSD));
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.MSD));
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.CFD));
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.AODD));
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.JMSCFDD));
        allResourceDescriptors.addAll(this.getResourceDescriptors(JavaEEResourceType.JMSDD));
        return allResourceDescriptors;
    }

    public Set<ResourceDescriptor> getAllResourcesDescriptors(Class givenClazz) {
        HashSet<ResourceDescriptor> allResourceDescriptors = new HashSet<ResourceDescriptor>();
        for (JavaEEResourceType javaEEResourceType : JavaEEResourceType.values()) {
            Set<Class> invalidClassSet = invalidResourceTypeScopes.get(javaEEResourceType);
            if (invalidClassSet != null && invalidClassSet.size() > 0) {
                for (Class invalidClass : invalidClassSet) {
                    if (invalidClass.isAssignableFrom(givenClazz)) continue;
                    allResourceDescriptors.addAll(this.getResourceDescriptors(javaEEResourceType));
                }
                continue;
            }
            if (invalidClassSet == null) continue;
            allResourceDescriptors.addAll(this.getResourceDescriptors(javaEEResourceType));
        }
        return allResourceDescriptors;
    }

    protected ResourceDescriptor getResourcesDescriptor(String name) {
        ResourceDescriptor descriptor = null;
        for (ResourceDescriptor thiDescriptor : this.getAllResourcesDescriptors()) {
            if (!thiDescriptor.getName().equals(name)) continue;
            descriptor = thiDescriptor;
            break;
        }
        return descriptor;
    }

    private boolean isDescriptorRegistered(ResourceDescriptor reference) {
        ResourceDescriptor descriptor = this.getResourcesDescriptor(reference.getName());
        return descriptor != null;
    }

    public Set<ResourceDescriptor> getResourceDescriptors(JavaEEResourceType javaEEResourceType) {
        Set<ResourceDescriptor> resourceDescriptorSet = this.resourceDescriptors.get(javaEEResourceType);
        if (resourceDescriptorSet == null) {
            this.resourceDescriptors.put(javaEEResourceType, new HashSet());
        }
        return this.resourceDescriptors.get(javaEEResourceType);
    }

    protected ResourceDescriptor getResourceDescriptor(JavaEEResourceType javaEEResourceType, String name) {
        for (ResourceDescriptor resourceDescriptor : this.getResourceDescriptors(javaEEResourceType)) {
            if (!resourceDescriptor.getName().equals(name)) continue;
            return resourceDescriptor;
        }
        return null;
    }

    public void addResourceDescriptor(ResourceDescriptor reference) {
        if (this.isDescriptorRegistered(reference)) {
            throw new IllegalStateException(localStrings.getLocalString("exceptionwebduplicatedescriptor", "This app cannot have descriptor definitions of same name : [{0}]", new Object[]{reference.getName()}));
        }
        Set<ResourceDescriptor> resourceDescriptorSet = this.getResourceDescriptors(reference.getResourceType());
        resourceDescriptorSet.add(reference);
        this.resourceDescriptors.put(reference.getResourceType(), resourceDescriptorSet);
    }

    public void removeResourceDescriptor(JavaEEResourceType javaEEResourceType, ResourceDescriptor reference) {
        Set<ResourceDescriptor> resourceDescriptorSet = this.getResourceDescriptors(reference.getResourceType());
        resourceDescriptorSet.remove((Object)reference);
        this.resourceDescriptors.put(javaEEResourceType, resourceDescriptorSet);
    }

    static {
        invalidResourceTypeScopes.put(JavaEEResourceType.MSD, new HashSet());
        invalidResourceTypeScopes.put(JavaEEResourceType.DSD, new HashSet());
        invalidResourceTypeScopes.put(JavaEEResourceType.JMSCFDD, new HashSet());
        invalidResourceTypeScopes.put(JavaEEResourceType.JMSDD, new HashSet());
        invalidResourceTypeScopes.put(JavaEEResourceType.CFD, new HashSet<Class>(Arrays.asList(ApplicationClientDescriptor.class)));
        invalidResourceTypeScopes.put(JavaEEResourceType.AODD, new HashSet<Class>(Arrays.asList(ApplicationClientDescriptor.class)));
        localStrings = new LocalStringManagerImpl(ResourceDescriptorRegistry.class);
    }
}

