/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.TransactionFailure;

public class PortBaseHelper {
    private static final LocalStringsImpl strings = new LocalStringsImpl(PortBaseHelper.class);
    private String portBase;
    private boolean checkPorts;
    private String adminPort;
    private String instancePort;
    private String httpsPort;
    private String iiopPort;
    private String iiopmPort;
    private String iiopsPort;
    private String jmsPort;
    private String jmxPort;
    private String osgiPort;
    private String debugPort;
    private Logger _logger;
    private Server _server;

    public PortBaseHelper(Server instance, String portbase, boolean checkports, Logger logger) {
        this.portBase = portbase;
        this.checkPorts = checkports;
        this._logger = logger;
        this._server = instance;
    }

    public void verifyPortBase() throws TransactionFailure {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.portBase);
            this.setOptionsWithPortBase(portbase);
        }
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public String getIiopPort() {
        return this.iiopPort;
    }

    public String getIiopsPort() {
        return this.iiopsPort;
    }

    public String getIiopmPort() {
        return this.iiopmPort;
    }

    public String getJmsPort() {
        return this.jmsPort;
    }

    public String getJmxPort() {
        return this.jmxPort;
    }

    public String getOsgiPort() {
        return this.osgiPort;
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    private int convertPortStr(String port) throws TransactionFailure {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new TransactionFailure(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private boolean usePortBase() throws TransactionFailure {
        return this.portBase != null;
    }

    private void setOptionsWithPortBase(int portbase) throws TransactionFailure {
        this.verifyPortBasePortIsValid("ASADMIN_LISTENER_PORT", portbase + 48);
        this.adminPort = String.valueOf(portbase + 48);
        this.verifyPortBasePortIsValid("HTTP_LISTENER_PORT", portbase + 80);
        this.instancePort = String.valueOf(portbase + 80);
        this.verifyPortBasePortIsValid("HTTP_SSL_LISTENER_PORT", portbase + 81);
        this.httpsPort = String.valueOf(portbase + 81);
        this.verifyPortBasePortIsValid("IIOP_SSL_LISTENER_PORT", portbase + 38);
        this.iiopsPort = String.valueOf(portbase + 38);
        this.verifyPortBasePortIsValid("IIOP_SSL_MUTUALAUTH_PORT", portbase + 39);
        this.iiopmPort = String.valueOf(portbase + 39);
        this.verifyPortBasePortIsValid("JMS_PROVIDER_PORT", portbase + 76);
        this.jmsPort = String.valueOf(portbase + 76);
        this.verifyPortBasePortIsValid("IIOP_LISTENER_PORT", portbase + 37);
        this.iiopPort = String.valueOf(portbase + 37);
        this.verifyPortBasePortIsValid("JMX_SYSTEM_CONNECTOR_PORT", portbase + 86);
        this.jmxPort = String.valueOf(portbase + 86);
        this.verifyPortBasePortIsValid("OSGI_SHELL_TELNET_PORT", portbase + 66);
        this.osgiPort = String.valueOf(portbase + 66);
        this.verifyPortBasePortIsValid("JAVA_DEBUGGER_PORT", portbase + 9);
        this.debugPort = String.valueOf(portbase + 9);
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws TransactionFailure {
        if (portNum <= 0 || portNum > 65535) {
            throw new TransactionFailure(strings.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new TransactionFailure(strings.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        this._logger.log(Level.FINER, "NCLS-ADMIN-00019", portNum);
    }

    public void setPorts() throws TransactionFailure, PropertyVetoException {
        if (this.portBase != null) {
            this.setSystemProperty("ASADMIN_LISTENER_PORT", this.getAdminPort());
            this.setSystemProperty("HTTP_LISTENER_PORT", this.getInstancePort());
            this.setSystemProperty("HTTP_SSL_LISTENER_PORT", this.getHttpsPort());
            this.setSystemProperty("IIOP_LISTENER_PORT", this.getIiopPort());
            this.setSystemProperty("IIOP_SSL_MUTUALAUTH_PORT", this.getIiopmPort());
            this.setSystemProperty("IIOP_SSL_LISTENER_PORT", this.getIiopsPort());
            this.setSystemProperty("JMS_PROVIDER_PORT", this.getJmsPort());
            this.setSystemProperty("JMX_SYSTEM_CONNECTOR_PORT", this.getJmxPort());
            this.setSystemProperty("OSGI_SHELL_TELNET_PORT", this.getOsgiPort());
            this.setSystemProperty("JAVA_DEBUGGER_PORT", this.getDebugPort());
        }
    }

    private void setSystemProperty(String name, String value) throws TransactionFailure, PropertyVetoException {
        SystemProperty sp = this._server.getSystemProperty(name);
        if (sp == null) {
            SystemProperty newSP = (SystemProperty)this._server.createChild(SystemProperty.class);
            newSP.setName(name);
            newSP.setValue(value);
            this._server.getSystemProperty().add(newSP);
        }
    }
}

