/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.monitoring.RequestEvent;

class ContainerFilteringStage
extends AbstractChainableStage<ContainerRequest> {
    private ServiceLocator locator;
    private final Iterable<RankedProvider<ContainerRequestFilter>> requestFilters;
    private final Iterable<RankedProvider<ContainerResponseFilter>> responseFilters;
    private final Provider<RespondingContext> respondingContextFactory;

    private ContainerFilteringStage(Provider<RespondingContext> respondingContextFactory, ServiceLocator locator, Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
        this.respondingContextFactory = respondingContextFactory;
        this.locator = locator;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stage.Continuation<ContainerRequest> apply(ContainerRequest requestContext) {
        Iterable sortedRequestFilters;
        boolean postMatching;
        boolean bl = postMatching = this.responseFilters == null;
        if (postMatching) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            sortedRequestFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.requestFilters, rc.getBoundRequestFilters()});
            requestContext.getRequestEventBuilder().setContainerRequestFilters(sortedRequestFilters);
            requestContext.triggerEvent(RequestEvent.Type.REQUEST_MATCHED);
        } else {
            ((RespondingContext)this.respondingContextFactory.get()).push((ChainableStage<ContainerResponse>)new ResponseFilterStage(this.responseFilters, this.locator));
            sortedRequestFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.requestFilters});
        }
        try {
            for (ContainerRequestFilter filter : sortedRequestFilters) {
                try {
                    filter.filter((ContainerRequestContext)requestContext);
                }
                catch (WebApplicationException wae) {
                    throw wae;
                }
                catch (Exception exception) {
                    throw new MappableException(exception);
                }
                final Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) continue;
                Stage.Continuation continuation = Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Endpoint(){

                    public ContainerResponse apply(ContainerRequest requestContext) {
                        return new ContainerResponse(requestContext, abortResponse);
                    }
                }));
                return continuation;
            }
        }
        finally {
            if (postMatching) {
                requestContext.triggerEvent(RequestEvent.Type.REQUEST_FILTERED);
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        protected void configure() {
            this.bindAsContract(Builder.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ContainerResponse> {
        private final Iterable<RankedProvider<ContainerResponseFilter>> filters;
        private final ServiceLocator locator;

        private ResponseFilterStage(Iterable<RankedProvider<ContainerResponseFilter>> filters, ServiceLocator locator) {
            this.filters = filters;
            this.locator = locator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Stage.Continuation<ContainerResponse> apply(ContainerResponse responseContext) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            Iterable sortedResponseFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(RankedComparator.Order.DESCENDING), (Iterable[])new Iterable[]{this.filters, rc.getBoundResponseFilters()});
            ContainerRequest request = responseContext.getRequestContext();
            request.getRequestEventBuilder().setContainerResponseFilters(sortedResponseFilters);
            request.triggerEvent(RequestEvent.Type.RESP_FILTERS_START);
            try {
                for (ContainerResponseFilter filter : sortedResponseFilters) {
                    try {
                        filter.filter((ContainerRequestContext)request, (ContainerResponseContext)responseContext);
                    }
                    catch (WebApplicationException wae) {
                        throw wae;
                    }
                    catch (Exception ex) {
                        throw new MappableException(ex);
                        return Stage.Continuation.of((Object)responseContext, (Stage)this.getDefaultNext());
                    }
                }
            }
            finally {
                request.triggerEvent(RequestEvent.Type.RESP_FILTERS_FINISHED);
            }
        }
    }

    static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        private Provider<RespondingContext> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
            return new ContainerFilteringStage(this.respondingContextFactory, this.locator, requestFilters, responseFilters);
        }
    }
}

