/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;

class PushMatchedMethodResourceRouter
implements Router {
    private final ResourceMethod resourceMethod;
    private final Resource resource;
    private final Provider<RoutingContext> routingContext;

    private PushMatchedMethodResourceRouter(ResourceMethod resourceMethod, Resource resource, Provider<RoutingContext> routingContext) {
        this.resourceMethod = resourceMethod;
        this.resource = resource;
        this.routingContext = routingContext;
    }

    @Override
    public Router.Continuation apply(ContainerRequest data) {
        ((RoutingContext)this.routingContext.get()).setMatchedResource(this.resource);
        ((RoutingContext)this.routingContext.get()).setMatchedResourceMethod(this.resourceMethod);
        return Router.Continuation.of(data);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContext;

        Builder() {
        }

        PushMatchedMethodResourceRouter build(Resource resource, ResourceMethod method) {
            return new PushMatchedMethodResourceRouter(method, resource, this.routingContext);
        }
    }
}

