/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.nio.ByteBuffer;
import java.util.Vector;
import org.gdal.gdal.Band;
import org.gdal.gdal.Driver;
import org.gdal.gdal.GCP;
import org.gdal.gdal.MajorObject;
import org.gdal.gdal.ProgressCallback;
import org.gdal.gdal.SWIGTYPE_p_int;
import org.gdal.gdal.gdalJNI;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.StyleTable;
import org.gdal.osr.SpatialReference;

public class Dataset
extends MajorObject {
    private transient long swigCPtr;

    protected Dataset(long cPtr, boolean cMemoryOwn) {
        super(gdalJNI.Dataset_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Dataset obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                gdalJNI.delete_Dataset(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public int GetRasterXSize() {
        return this.getRasterXSize();
    }

    public int GetRasterYSize() {
        return this.getRasterYSize();
    }

    public int GetRasterCount() {
        return this.getRasterCount();
    }

    public int BuildOverviews(int[] overviewlist, ProgressCallback callback) {
        return this.BuildOverviews(null, overviewlist, callback);
    }

    public int BuildOverviews(int[] overviewlist) {
        return this.BuildOverviews(null, overviewlist, null);
    }

    public Vector GetGCPs() {
        Vector gcps = new Vector();
        this.GetGCPs(gcps);
        return gcps;
    }

    public double[] GetGeoTransform() {
        double[] adfGeoTransform = new double[6];
        this.GetGeoTransform(adfGeoTransform);
        return adfGeoTransform;
    }

    public Layer GetLayer(int index) {
        return this.GetLayerByIndex(index);
    }

    public Layer GetLayer(String layerName) {
        return this.GetLayerByName(layerName);
    }

    public int getRasterXSize() {
        return gdalJNI.Dataset_RasterXSize_get(this.swigCPtr, this);
    }

    public int getRasterYSize() {
        return gdalJNI.Dataset_RasterYSize_get(this.swigCPtr, this);
    }

    public int getRasterCount() {
        return gdalJNI.Dataset_RasterCount_get(this.swigCPtr, this);
    }

    public Driver GetDriver() {
        long cPtr = gdalJNI.Dataset_GetDriver(this.swigCPtr, this);
        return cPtr == 0L ? null : new Driver(cPtr, false);
    }

    public Band GetRasterBand(int nBand) {
        long cPtr = gdalJNI.Dataset_GetRasterBand(this.swigCPtr, this, nBand);
        Band ret = null;
        if (cPtr != 0L) {
            ret = new Band(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public String GetProjection() {
        return gdalJNI.Dataset_GetProjection(this.swigCPtr, this);
    }

    public String GetProjectionRef() {
        return gdalJNI.Dataset_GetProjectionRef(this.swigCPtr, this);
    }

    public SpatialReference GetSpatialRef() {
        long cPtr = gdalJNI.Dataset_GetSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public int SetProjection(String prj) {
        return gdalJNI.Dataset_SetProjection(this.swigCPtr, this, prj);
    }

    public void SetSpatialRef(SpatialReference srs) {
        gdalJNI.Dataset_SetSpatialRef(this.swigCPtr, this, SpatialReference.getCPtr(srs), srs);
    }

    public void GetGeoTransform(double[] argout) {
        gdalJNI.Dataset_GetGeoTransform(this.swigCPtr, this, argout);
    }

    public int SetGeoTransform(double[] argin) {
        return gdalJNI.Dataset_SetGeoTransform(this.swigCPtr, this, argin);
    }

    public int BuildOverviews(String resampling, int[] overviewlist, ProgressCallback callback) {
        return gdalJNI.Dataset_BuildOverviews__SWIG_0(this.swigCPtr, this, resampling, overviewlist, callback);
    }

    public int BuildOverviews(String resampling, int[] overviewlist) {
        return gdalJNI.Dataset_BuildOverviews__SWIG_2(this.swigCPtr, this, resampling, overviewlist);
    }

    public int GetGCPCount() {
        return gdalJNI.Dataset_GetGCPCount(this.swigCPtr, this);
    }

    public String GetGCPProjection() {
        return gdalJNI.Dataset_GetGCPProjection(this.swigCPtr, this);
    }

    public SpatialReference GetGCPSpatialRef() {
        long cPtr = gdalJNI.Dataset_GetGCPSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public void GetGCPs(Vector nGCPs) {
        gdalJNI.Dataset_GetGCPs(this.swigCPtr, this, nGCPs);
    }

    public int SetGCPs(GCP[] nGCPs, String pszGCPProjection) {
        return gdalJNI.Dataset_SetGCPs(this.swigCPtr, this, nGCPs, pszGCPProjection);
    }

    public int SetGCPs2(GCP[] nGCPs, SpatialReference hSRS) {
        return gdalJNI.Dataset_SetGCPs2(this.swigCPtr, this, nGCPs, SpatialReference.getCPtr(hSRS), hSRS);
    }

    public void FlushCache() {
        gdalJNI.Dataset_FlushCache(this.swigCPtr, this);
    }

    public int AddBand(int datatype, Vector options) {
        return gdalJNI.Dataset_AddBand__SWIG_0(this.swigCPtr, this, datatype, options);
    }

    public int AddBand(int datatype) {
        return gdalJNI.Dataset_AddBand__SWIG_1(this.swigCPtr, this, datatype);
    }

    public int AddBand() {
        return gdalJNI.Dataset_AddBand__SWIG_2(this.swigCPtr, this);
    }

    public int CreateMaskBand(int nFlags) {
        return gdalJNI.Dataset_CreateMaskBand(this.swigCPtr, this, nFlags);
    }

    public Vector GetFileList() {
        return gdalJNI.Dataset_GetFileList(this.swigCPtr, this);
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize, SWIGTYPE_p_int buf_xsize, SWIGTYPE_p_int buf_ysize, SWIGTYPE_p_int buf_type, int[] band_list, Vector options) {
        return gdalJNI.Dataset_AdviseRead__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, SWIGTYPE_p_int.getCPtr(buf_xsize), SWIGTYPE_p_int.getCPtr(buf_ysize), SWIGTYPE_p_int.getCPtr(buf_type), band_list, options);
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize, SWIGTYPE_p_int buf_xsize, SWIGTYPE_p_int buf_ysize, SWIGTYPE_p_int buf_type, int[] band_list) {
        return gdalJNI.Dataset_AdviseRead__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, SWIGTYPE_p_int.getCPtr(buf_xsize), SWIGTYPE_p_int.getCPtr(buf_ysize), SWIGTYPE_p_int.getCPtr(buf_type), band_list);
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize, SWIGTYPE_p_int buf_xsize, SWIGTYPE_p_int buf_ysize, SWIGTYPE_p_int buf_type) {
        return gdalJNI.Dataset_AdviseRead__SWIG_3(this.swigCPtr, this, xoff, yoff, xsize, ysize, SWIGTYPE_p_int.getCPtr(buf_xsize), SWIGTYPE_p_int.getCPtr(buf_ysize), SWIGTYPE_p_int.getCPtr(buf_type));
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize, SWIGTYPE_p_int buf_xsize, SWIGTYPE_p_int buf_ysize) {
        return gdalJNI.Dataset_AdviseRead__SWIG_4(this.swigCPtr, this, xoff, yoff, xsize, ysize, SWIGTYPE_p_int.getCPtr(buf_xsize), SWIGTYPE_p_int.getCPtr(buf_ysize));
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize, SWIGTYPE_p_int buf_xsize) {
        return gdalJNI.Dataset_AdviseRead__SWIG_5(this.swigCPtr, this, xoff, yoff, xsize, ysize, SWIGTYPE_p_int.getCPtr(buf_xsize));
    }

    public int AdviseRead(int xoff, int yoff, int xsize, int ysize) {
        return gdalJNI.Dataset_AdviseRead__SWIG_6(this.swigCPtr, this, xoff, yoff, xsize, ysize);
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type, Vector options) {
        long cPtr = gdalJNI.Dataset_CreateLayer__SWIG_0(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type) {
        long cPtr = gdalJNI.Dataset_CreateLayer__SWIG_1(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs) {
        long cPtr = gdalJNI.Dataset_CreateLayer__SWIG_2(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name) {
        long cPtr = gdalJNI.Dataset_CreateLayer__SWIG_3(this.swigCPtr, this, name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name, Vector options) {
        long cPtr = gdalJNI.Dataset_CopyLayer__SWIG_0(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name) {
        long cPtr = gdalJNI.Dataset_CopyLayer__SWIG_1(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int DeleteLayer(int index) {
        return gdalJNI.Dataset_DeleteLayer(this.swigCPtr, this, index);
    }

    public int GetLayerCount() {
        return gdalJNI.Dataset_GetLayerCount(this.swigCPtr, this);
    }

    public Layer GetLayerByIndex(int index) {
        long cPtr = gdalJNI.Dataset_GetLayerByIndex(this.swigCPtr, this, index);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByName(String layer_name) {
        long cPtr = gdalJNI.Dataset_GetLayerByName(this.swigCPtr, this, layer_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public void ResetReading() {
        gdalJNI.Dataset_ResetReading(this.swigCPtr, this);
    }

    public Feature GetNextFeature() {
        long cPtr = gdalJNI.Dataset_GetNextFeature(this.swigCPtr, this);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public boolean TestCapability(String cap) {
        return gdalJNI.Dataset_TestCapability(this.swigCPtr, this, cap);
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter, String dialect) {
        long cPtr = gdalJNI.Dataset_ExecuteSQL__SWIG_0(this.swigCPtr, this, statement, Geometry.getCPtr(spatialFilter), spatialFilter, dialect);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter) {
        long cPtr = gdalJNI.Dataset_ExecuteSQL__SWIG_1(this.swigCPtr, this, statement, Geometry.getCPtr(spatialFilter), spatialFilter);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement) {
        long cPtr = gdalJNI.Dataset_ExecuteSQL__SWIG_2(this.swigCPtr, this, statement);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public void ReleaseResultSet(Layer layer) {
        gdalJNI.Dataset_ReleaseResultSet(this.swigCPtr, this, Layer.getCPtrAndDisown(layer), layer);
    }

    public StyleTable GetStyleTable() {
        long cPtr = gdalJNI.Dataset_GetStyleTable(this.swigCPtr, this);
        return cPtr == 0L ? null : new StyleTable(cPtr, false);
    }

    public void SetStyleTable(StyleTable table) {
        gdalJNI.Dataset_SetStyleTable(this.swigCPtr, this, StyleTable.getCPtr(table), table);
    }

    public int StartTransaction(int force) {
        return gdalJNI.Dataset_StartTransaction__SWIG_0(this.swigCPtr, this, force);
    }

    public int StartTransaction() {
        return gdalJNI.Dataset_StartTransaction__SWIG_1(this.swigCPtr, this);
    }

    public int CommitTransaction() {
        return gdalJNI.Dataset_CommitTransaction(this.swigCPtr, this);
    }

    public int RollbackTransaction() {
        return gdalJNI.Dataset_RollbackTransaction(this.swigCPtr, this);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_2(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster_Direct__SWIG_3(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayOut, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_2(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayOut, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster__SWIG_3(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_4(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_5(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayOut, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_6(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayOut, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster__SWIG_7(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_8(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_9(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayOut, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_10(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayOut, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster__SWIG_11(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_12(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_13(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayOut, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_14(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayOut, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster__SWIG_15(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_16(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayOut, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_17(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace, nLineSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayOut, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_ReadRaster__SWIG_18(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list, nPixelSpace);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayOut, int[] band_list) {
        return gdalJNI.Dataset_ReadRaster__SWIG_19(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayOut, band_list);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_2(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list, nPixelSpace);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer nioBuffer, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster_Direct__SWIG_3(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, nioBuffer, band_list);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_0(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_1(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayIn, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_2(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, byte[] regularArrayIn, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster__SWIG_3(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_4(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_5(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayIn, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_6(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, short[] regularArrayIn, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster__SWIG_7(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_8(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_9(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayIn, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_10(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, int[] regularArrayIn, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster__SWIG_11(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_12(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_13(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayIn, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_14(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, float[] regularArrayIn, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster__SWIG_15(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace, int nBandSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_16(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace, nBandSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayIn, int[] band_list, int nPixelSpace, int nLineSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_17(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace, nLineSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayIn, int[] band_list, int nPixelSpace) {
        return gdalJNI.Dataset_WriteRaster__SWIG_18(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list, nPixelSpace);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, double[] regularArrayIn, int[] band_list) {
        return gdalJNI.Dataset_WriteRaster__SWIG_19(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, regularArrayIn, band_list);
    }
}

