/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.gdal.MajorObject;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.StyleTable;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.SpatialReference;

public class DataSource
extends MajorObject {
    private long swigCPtr;

    protected DataSource(long cPtr, boolean cMemoryOwn) {
        super(ogrJNI.SWIGDataSourceUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DataSource obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                ogrJNI.delete_DataSource(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof DataSource) {
            equal = ((DataSource)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public Layer GetLayer(int index) {
        return this.GetLayerByIndex(index);
    }

    public Layer GetLayer(String layerName) {
        return this.GetLayerByName(layerName);
    }

    public String getName() {
        return ogrJNI.DataSource_name_get(this.swigCPtr, this);
    }

    public int GetRefCount() {
        return ogrJNI.DataSource_GetRefCount(this.swigCPtr, this);
    }

    public int GetSummaryRefCount() {
        return ogrJNI.DataSource_GetSummaryRefCount(this.swigCPtr, this);
    }

    public int GetLayerCount() {
        return ogrJNI.DataSource_GetLayerCount(this.swigCPtr, this);
    }

    public Driver GetDriver() {
        long cPtr = ogrJNI.DataSource_GetDriver(this.swigCPtr, this);
        return cPtr == 0L ? null : new Driver(cPtr, false);
    }

    public String GetName() {
        return ogrJNI.DataSource_GetName(this.swigCPtr, this);
    }

    public int DeleteLayer(int index) {
        return ogrJNI.DataSource_DeleteLayer(this.swigCPtr, this, index);
    }

    public int SyncToDisk() {
        return ogrJNI.DataSource_SyncToDisk(this.swigCPtr, this);
    }

    public void FlushCache() {
        ogrJNI.DataSource_FlushCache(this.swigCPtr, this);
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type, Vector options) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_0(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_1(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_2(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_3(this.swigCPtr, this, name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name, Vector options) {
        long cPtr = ogrJNI.DataSource_CopyLayer__SWIG_0(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name) {
        long cPtr = ogrJNI.DataSource_CopyLayer__SWIG_1(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByIndex(int index) {
        long cPtr = ogrJNI.DataSource_GetLayerByIndex(this.swigCPtr, this, index);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByName(String layer_name) {
        long cPtr = ogrJNI.DataSource_GetLayerByName(this.swigCPtr, this, layer_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public boolean TestCapability(String cap) {
        return ogrJNI.DataSource_TestCapability(this.swigCPtr, this, cap);
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter, String dialect) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_0(this.swigCPtr, this, statement, Geometry.getCPtr(spatialFilter), spatialFilter, dialect);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_1(this.swigCPtr, this, statement, Geometry.getCPtr(spatialFilter), spatialFilter);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_2(this.swigCPtr, this, statement);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public void ReleaseResultSet(Layer layer) {
        ogrJNI.DataSource_ReleaseResultSet(this.swigCPtr, this, Layer.getCPtrAndDisown(layer), layer);
    }

    public StyleTable GetStyleTable() {
        long cPtr = ogrJNI.DataSource_GetStyleTable(this.swigCPtr, this);
        return cPtr == 0L ? null : new StyleTable(cPtr, false);
    }

    public void SetStyleTable(StyleTable table) {
        ogrJNI.DataSource_SetStyleTable(this.swigCPtr, this, StyleTable.getCPtr(table), table);
    }

    public int StartTransaction(int force) {
        return ogrJNI.DataSource_StartTransaction__SWIG_0(this.swigCPtr, this, force);
    }

    public int StartTransaction() {
        return ogrJNI.DataSource_StartTransaction__SWIG_1(this.swigCPtr, this);
    }

    public int CommitTransaction() {
        return ogrJNI.DataSource_CommitTransaction(this.swigCPtr, this);
    }

    public int RollbackTransaction() {
        return ogrJNI.DataSource_RollbackTransaction(this.swigCPtr, this);
    }
}

