/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.mvnplugins.uberize.DefaultUberizer;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheNoticeAgreggator
implements Transformer {
    private static final String NOTICE_PATH = "META-INF/NOTICE";
    private static final String NOTICE_TXT_PATH = "META-INF/NOTICE.txt";
    String encoding;
    Map organizationEntries = new LinkedHashMap();
    String projectName;
    Set<String> notices;
    String organizationName = "The Apache Software Foundation";
    String organizationURL = "http://www.apache.org/";
    String inceptionYear = "2006";
    String copyright;

    @Override
    public void process(Uberizer uberizer, File workDir, TreeMap<String, UberEntry> uberEntries) throws IOException {
        LinkedHashSet<String> noticeSet = new LinkedHashSet<String>();
        if (this.notices == null) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            if (!this.inceptionYear.equals(year)) {
                year = this.inceptionYear + "-" + year;
            }
            noticeSet.add("// ------------------------------------------------------------------\n// NOTICE file corresponding to the section 4d of The Apache License,\n// Version 2.0, in this case for " + this.projectName + "\n" + "// ------------------------------------------------------------------\n");
            noticeSet.add(this.projectName + "\n" + "Copyright " + year + " " + this.organizationName + "\n");
            noticeSet.add("This product includes software developed at\n" + this.organizationName + " (" + this.organizationURL + ").\n");
        } else {
            noticeSet.addAll(this.notices);
        }
        ArrayList<UberEntry> matches = new ArrayList<UberEntry>();
        for (UberEntry entry : new ArrayList<UberEntry>(uberEntries.values())) {
            if (!ApacheNoticeAgreggator.matches(entry.getPath())) continue;
            for (File file : entry.getSources()) {
                this.processFile(file, noticeSet);
            }
            matches.add(entry);
        }
        File targetFile = DefaultUberizer.prepareFile(workDir, NOTICE_PATH);
        FileOutputStream jos = new FileOutputStream(targetFile);
        OutputStreamWriter pow = StringUtils.isNotEmpty((String)this.encoding) ? new OutputStreamWriter((OutputStream)jos, this.encoding) : new OutputStreamWriter(jos);
        PrintWriter writer = new PrintWriter(pow);
        int count = 0;
        for (String line : noticeSet) {
            if (line.equals(this.copyright) && ++count != 2) continue;
            if (count == 2 && this.copyright != null) {
                writer.print(this.copyright);
                writer.print('\n');
            } else {
                writer.print(line);
                writer.print('\n');
            }
            if (count != 3) continue;
            for (Map.Entry entry : this.organizationEntries.entrySet()) {
                writer.print(entry.getKey().toString());
                writer.print('\n');
                Set entrySet = (Set)entry.getValue();
                Iterator eit = entrySet.iterator();
                while (eit.hasNext()) {
                    writer.print(eit.next().toString());
                }
                writer.print('\n');
            }
        }
        writer.flush();
        UberEntry modEntry = new UberEntry(NOTICE_PATH, matches);
        modEntry.getSources().add(targetFile);
        uberEntries.put(modEntry.getPath(), modEntry);
    }

    static boolean matches(String resource) {
        return NOTICE_PATH.equalsIgnoreCase(resource) || NOTICE_TXT_PATH.equalsIgnoreCase(resource);
    }

    private void processFile(File file, Set<String> entries) throws IOException {
        BufferedReader reader = StringUtils.isNotEmpty((String)this.encoding) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding)) : new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        StringBuffer sb = new StringBuffer();
        Set<String> currentOrg = null;
        int lineCount = 0;
        while (line != null) {
            String trimedLine = line.trim();
            if (!trimedLine.startsWith("//")) {
                if (trimedLine.length() > 0) {
                    if (trimedLine.startsWith("- ")) {
                        if (lineCount == 1 && sb.toString().indexOf("This product includes/uses software(s) developed by") != -1) {
                            currentOrg = (Set)this.organizationEntries.get(sb.toString().trim());
                            if (currentOrg == null) {
                                currentOrg = new TreeSet<String>();
                                this.organizationEntries.put(sb.toString().trim(), currentOrg);
                            }
                            sb = new StringBuffer();
                        } else if (sb.length() > 0 && currentOrg != null) {
                            currentOrg.add(sb.toString());
                            sb = new StringBuffer();
                        }
                    }
                    sb.append(line).append("\n");
                    ++lineCount;
                } else {
                    String ent = sb.toString();
                    if (ent.startsWith(this.projectName) && ent.indexOf("Copyright ") != -1) {
                        this.copyright = ent;
                    }
                    if (currentOrg == null) {
                        entries.add(ent);
                    } else {
                        currentOrg.add(ent);
                    }
                    sb = new StringBuffer();
                    lineCount = 0;
                    currentOrg = null;
                }
            }
            line = reader.readLine();
        }
        if (sb.length() > 0) {
            if (currentOrg == null) {
                entries.add(sb.toString());
            } else {
                currentOrg.add(sb.toString());
            }
        }
    }
}

