/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.VariableContainerWrapper;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.api.FormModel;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.ExpressionFormField;
import org.flowable.form.model.FormField;
import org.flowable.form.model.Option;
import org.flowable.form.model.OptionFormField;
import org.flowable.form.model.SimpleFormModel;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFormModelWithVariablesCmd
implements Command<FormInfo>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFormModelWithVariablesCmd.class);
    private static final long serialVersionUID = 1L;
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-M-d");
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formDefinitionId;
    protected String taskId;
    protected String tenantId;
    protected Map<String, Object> variables;

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String formDefinitionId, String taskId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.taskId = taskId;
    }

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String taskId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.taskId = taskId;
    }

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String taskId, String tenantId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.taskId = taskId;
        this.tenantId = tenantId;
    }

    public FormInfo execute(CommandContext commandContext) {
        FormDefinitionCacheEntry formCacheEntry = this.resolveFormDefinition(commandContext);
        FormInstance formInstance = this.resolveFormInstance(formCacheEntry, commandContext);
        FormInfo formInfo = this.resolveFormModel(formCacheEntry, commandContext);
        this.fillFormFieldValues(formInstance, formInfo, commandContext);
        return formInfo;
    }

    protected void initializeValues(String formDefinitionKey, String formDefinitionId, String tenantId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(FormInstance formInstance, FormInfo formInfo, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        List allFields = formModel.listAllFields();
        if (allFields != null) {
            HashMap<String, JsonNode> formInstanceFieldMap = new HashMap<String, JsonNode>();
            if (formInstance != null) {
                this.fillFormInstanceValues(formInstance, formInstanceFieldMap, formEngineConfiguration.getObjectMapper());
                this.fillVariablesWithFormInstanceValues(formInstanceFieldMap, allFields, formInstance.getId());
            }
            for (FormField field : allFields) {
                Object dateVariable;
                Object variableValue;
                if (field instanceof OptionFormField) {
                    OptionFormField optionFormField = (OptionFormField)field;
                    if (optionFormField.getOptionsExpression() != null) {
                        Expression optionsExpression = formEngineConfiguration.getExpressionManager().createExpression(optionFormField.getOptionsExpression());
                        Object value = null;
                        try {
                            value = optionsExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables));
                        }
                        catch (Exception e) {
                            throw new FlowableException("Error getting value for optionsExpression: " + optionFormField.getOptionsExpression(), (Throwable)e);
                        }
                        if (value instanceof List) {
                            List options = (List)value;
                            optionFormField.setOptions(options);
                        } else if (value instanceof String) {
                            String json = (String)value;
                            try {
                                List options = (List)formEngineConfiguration.getObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Option>>(){});
                                optionFormField.setOptions(options);
                            }
                            catch (Exception e) {
                                throw new FlowableException("Error parsing optionsExpression json value: " + json, (Throwable)e);
                            }
                        } else {
                            throw new FlowableException("Invalid type from evaluated expression for optionsExpression: " + optionFormField.getOptionsExpression() + ", resulting type:" + value.getClass().getName());
                        }
                    }
                    Object variableValue2 = this.variables.get(field.getId());
                    optionFormField.setValue(variableValue2);
                    continue;
                }
                if ("hyperlink".equals(field.getType())) {
                    variableValue = this.variables.get(field.getId());
                    if (variableValue != null) {
                        field.setValue(variableValue);
                        continue;
                    }
                    if (field.getParam("hyperlinkUrl") == null) continue;
                    String hyperlinkUrl = field.getParam("hyperlinkUrl").toString();
                    Expression formExpression = formEngineConfiguration.getExpressionManager().createExpression(hyperlinkUrl);
                    try {
                        field.setValue(formExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables)));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error getting value for hyperlink expression {} {}", new Object[]{hyperlinkUrl, e.getMessage(), e});
                    }
                    continue;
                }
                if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    Expression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables)));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error getting value for expression {} {}", new Object[]{expressionField.getExpression(), e.getMessage(), e});
                    }
                    continue;
                }
                variableValue = this.variables.get(field.getId());
                if (variableValue == null) continue;
                if (variableValue instanceof LocalDate) {
                    dateVariable = (LocalDate)variableValue;
                    field.setValue((Object)dateVariable.toString("yyyy-M-d"));
                    continue;
                }
                if (variableValue instanceof Date) {
                    dateVariable = (Date)variableValue;
                    field.setValue((Object)DATE_FORMAT.format((Date)dateVariable));
                    continue;
                }
                field.setValue(variableValue);
            }
        }
    }

    protected FormDefinitionCacheEntry resolveFormDefinition(CommandContext commandContext) {
        DeploymentManager deploymentManager = CommandContextUtil.getFormEngineConfiguration().getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formCacheEntry;
    }

    protected void fillFormInstanceValues(FormInstance formInstance, Map<String, JsonNode> formInstanceFieldMap, ObjectMapper objectMapper) {
        if (formInstance == null) {
            return;
        }
        try {
            JsonNode submittedNode = objectMapper.readTree(formInstance.getFormValueBytes());
            if (submittedNode == null) {
                return;
            }
            if (submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Iterator fieldIdIterator = valuesNode.fieldNames();
                while (fieldIdIterator.hasNext()) {
                    String fieldId = (String)fieldIdIterator.next();
                    JsonNode valueNode = valuesNode.get(fieldId);
                    formInstanceFieldMap.put(fieldId, valueNode);
                }
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form instance " + formInstance.getId(), (Throwable)e);
        }
    }

    public void fillVariablesWithFormInstanceValues(Map<String, JsonNode> formInstanceFieldMap, List<FormField> allFields, String formInstanceId) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = formInstanceFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue.toString("yyyy-M-d"));
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing form date value for form instance {} with value {}", new Object[]{formInstanceId, fieldValue, e});
                }
                continue;
            }
            if (fieldValueNode.isBoolean()) {
                this.variables.put(field.getId(), fieldValueNode.asBoolean());
                continue;
            }
            if (fieldValueNode.isLong()) {
                this.variables.put(field.getId(), fieldValueNode.asLong());
                continue;
            }
            if (fieldValueNode.isDouble()) {
                this.variables.put(field.getId(), fieldValueNode.asDouble());
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected FormInstance resolveFormInstance(FormDefinitionCacheEntry formCacheEntry, CommandContext commandContext) {
        if (this.taskId == null) {
            return null;
        }
        List formInstances = ((FormInstanceQuery)CommandContextUtil.getFormEngineConfiguration().getFormService().createFormInstanceQuery().formDefinitionId(formCacheEntry.getFormDefinitionEntity().getId()).taskId(this.taskId).orderBySubmittedDate().desc()).list();
        if (formInstances.size() > 0) {
            return (FormInstance)formInstances.get(0);
        }
        return null;
    }

    protected FormInfo resolveFormModel(FormDefinitionCacheEntry formCacheEntry, CommandContext commandContext) {
        FormDefinitionEntity formEntity = formCacheEntry.getFormDefinitionEntity();
        FormJsonConverter formJsonConverter = CommandContextUtil.getFormEngineConfiguration().getFormJsonConverter();
        SimpleFormModel formModel = formJsonConverter.convertToFormModel(formCacheEntry.getFormDefinitionJson());
        FormInfo formInfo = new FormInfo();
        formInfo.setId(formEntity.getId());
        formInfo.setName(formEntity.getName());
        formInfo.setKey(formEntity.getKey());
        formInfo.setVersion(formEntity.getVersion());
        formInfo.setFormModel((FormModel)formModel);
        return formInfo;
    }
}

